/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.license.AbstractLicenseNameMojo;
import org.codehaus.mojo.license.FileState;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.codehaus.mojo.license.model.License;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="remove-file-header", threadSafe=true)
public class RemoveFileHeaderMojo
extends AbstractLicenseNameMojo {
    @Parameter(property="license.skipRemoveLicense", defaultValue="false")
    private boolean skipRemoveLicense;
    @Parameter(property="dryRun", defaultValue="false")
    private boolean dryRun;
    @Parameter(property="license.ignoreNoFileToScan", defaultValue="false")
    private boolean ignoreNoFileToScan;
    @Parameter(property="license.roots")
    private String[] roots;
    @Parameter(property="license.includes")
    private String[] includes;
    @Parameter(property="license.excludes")
    private String[] excludes;
    @Parameter
    private Map<String, String> extraExtensions;
    @Parameter
    private Map<String, String> extraFiles;
    @Parameter(property="license.ignoreTag")
    private String ignoreTag;
    @Component(role=FileHeaderTransformer.class)
    private Map<String, FileHeaderTransformer> transformers;
    private long timestamp;
    private Template descriptionTemplate0;
    private Set<File> processedFiles;
    private EnumMap<FileState, Set<File>> result;
    private Map<String, List<File>> filesToTreatByCommentStyle;

    @Override
    public boolean isSkip() {
        return this.skipRemoveLicense;
    }

    @Override
    public void init() throws Exception {
        FileHeaderTransformer aTransformer;
        if (StringUtils.isEmpty((CharSequence)this.ignoreTag)) {
            this.ignoreTag = "%%Ignore-License";
        }
        if (this.isVerbose()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("config - available comment styles :");
            String commentFormat = "\n  * %1$s (%2$s)";
            for (String transformerName : this.transformers.keySet()) {
                aTransformer = this.getTransformer(this.transformers, transformerName);
                String str = String.format(commentFormat, aTransformer.getName(), aTransformer.getDescription());
                buffer.append(str);
            }
            this.getLog().info((CharSequence)buffer.toString());
        }
        this.timestamp = System.nanoTime();
        super.init();
        if (this.roots == null || this.roots.length == 0) {
            this.roots = DEFAULT_ROOTS;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will use default roots " + Arrays.toString(this.roots)));
            }
        }
        if (this.includes == null || this.includes.length == 0) {
            this.includes = DEFAULT_INCLUDES;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will use default includes " + Arrays.toString(this.includes)));
            }
        }
        if (this.excludes == null || this.excludes.length == 0) {
            this.excludes = DEFAULT_EXCLUDES;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will use default excludes" + Arrays.toString(this.excludes)));
            }
        }
        TreeMap<String, String> extensionToCommentStyle = new TreeMap<String, String>();
        for (Map.Entry<String, FileHeaderTransformer> entry : this.transformers.entrySet()) {
            String[] extensions;
            String commentStyle = entry.getKey();
            aTransformer = entry.getValue();
            for (String extension : extensions = aTransformer.getDefaultAcceptedExtensions()) {
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Associate extension " + extension + " to comment style " + commentStyle));
                }
                extensionToCommentStyle.put(extension, commentStyle);
            }
        }
        if (this.extraExtensions != null) {
            for (Map.Entry<String, Object> entry : this.extraExtensions.entrySet()) {
                String extension = entry.getKey();
                if (extensionToCommentStyle.containsKey(extension)) {
                    this.getLog().warn((CharSequence)("The extension " + extension + " is already accepted for comment style " + (String)extensionToCommentStyle.get(extension)));
                }
                String commentStyle = (String)entry.getValue();
                this.getTransformer(this.transformers, commentStyle);
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Associate extension '" + extension + "' to comment style '" + commentStyle + "'"));
                }
                extensionToCommentStyle.put(extension, commentStyle);
            }
        }
        if (this.extraFiles == null) {
            this.extraFiles = Collections.emptyMap();
        }
        this.filesToTreatByCommentStyle = this.obtainFilesToProcessByCommentStyle(this.extraFiles, this.roots, this.includes, this.excludes, extensionToCommentStyle, this.transformers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doAction() throws Exception {
        block11: {
            int nbFiles2;
            long t0;
            block10: {
                t0 = System.nanoTime();
                this.processedFiles = new HashSet<File>();
                this.result = new EnumMap(FileState.class);
                try {
                    for (Map.Entry<String, List<File>> commentStyleFiles : this.filesToTreatByCommentStyle.entrySet()) {
                        String commentStyle = commentStyleFiles.getKey();
                        List<File> files = commentStyleFiles.getValue();
                        this.processCommentStyle(commentStyle, files);
                    }
                    Object var8_6 = null;
                    nbFiles2 = this.processedFiles.size();
                    if (nbFiles2 != 0 || this.ignoreNoFileToScan) break block10;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    int nbFiles2 = this.processedFiles.size();
                    if (nbFiles2 == 0 && !this.ignoreNoFileToScan) {
                        this.getLog().warn((CharSequence)"No file to scan.");
                    } else {
                        String delay = MojoHelper.convertTime(System.nanoTime() - t0);
                        String message = String.format("Scan %s file%s header done in %s.", nbFiles2, nbFiles2 > 1 ? "s" : "", delay);
                        this.getLog().info((CharSequence)message);
                    }
                    Set<FileState> states = this.result.keySet();
                    if (states.size() == 1 && states.contains((Object)FileState.uptodate)) {
                        this.getLog().info((CharSequence)"All files are up-to-date.");
                        throw throwable;
                    } else {
                        StringBuilder buffer = new StringBuilder();
                        for (FileState state : FileState.values()) {
                            this.reportType(this.result, state, buffer);
                        }
                        this.getLog().info((CharSequence)buffer.toString());
                    }
                    throw throwable;
                }
                this.getLog().warn((CharSequence)"No file to scan.");
                break block11;
            }
            String delay = MojoHelper.convertTime(System.nanoTime() - t0);
            String message = String.format("Scan %s file%s header done in %s.", nbFiles2, nbFiles2 > 1 ? "s" : "", delay);
            this.getLog().info((CharSequence)message);
        }
        Set<FileState> states = this.result.keySet();
        if (states.size() == 1 && states.contains((Object)FileState.uptodate)) {
            this.getLog().info((CharSequence)"All files are up-to-date.");
            return;
        }
        StringBuilder buffer = new StringBuilder();
        for (FileState state : FileState.values()) {
            this.reportType(this.result, state, buffer);
        }
        this.getLog().info((CharSequence)buffer.toString());
        return;
    }

    private boolean isDryRun() {
        return this.dryRun;
    }

    private void processCommentStyle(String commentStyle, List<File> filesToTreat) throws IOException {
        License license = this.getLicense(this.getLicenseName(), true);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Process header '" + commentStyle + "'"));
            this.getLog().info((CharSequence)(" - using " + license.getDescription()));
        }
        FileHeaderTransformer transformer = this.getTransformer(this.transformers, commentStyle);
        for (File file : filesToTreat) {
            this.processFile(transformer, file);
        }
        filesToTreat.clear();
    }

    private boolean processFile(FileHeaderTransformer transformer, File file, File processFile) throws IOException {
        String content;
        try {
            content = FileUtil.readAsString(file, this.getEncoding());
        }
        catch (IOException e) {
            throw new IOException("Could not obtain content of file " + file);
        }
        if (content.contains(this.ignoreTag)) {
            this.getLog().info((CharSequence)(" - ignore file (detected " + this.ignoreTag + ") " + file));
            FileState.ignore.addFile(file, this.result);
            return false;
        }
        String commentStartTag = transformer.getCommentStartTag();
        int firstIndex = content.indexOf(commentStartTag);
        if (firstIndex == -1) {
            FileState.uptodate.addFile(file, this.result);
            return false;
        }
        int lastchar = 32;
        while (lastchar != 10) {
            lastchar = content.charAt(--firstIndex);
        }
        String commentEndTag = transformer.getCommentEndTag();
        int lastIndex = content.indexOf(commentEndTag);
        if (lastIndex == -1) {
            FileState.uptodate.addFile(file, this.result);
            return false;
        }
        lastchar = 32;
        while (lastchar != 10) {
            lastchar = content.charAt(++lastIndex);
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)(" - header was removed for " + file));
        }
        String contentWithoutHeader = content.substring(0, firstIndex) + content.substring(lastIndex);
        FileUtils.fileWrite((File)processFile, (String)contentWithoutHeader);
        FileState.remove.addFile(file, this.result);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processFile(FileHeaderTransformer transformer, File file) throws IOException {
        if (this.processedFiles.contains(file)) {
            this.getLog().info((CharSequence)(" - skip already processed file " + file));
            return;
        }
        File processFile = new File(file.getAbsolutePath() + "_" + this.timestamp);
        boolean doFinalize = false;
        try {
            try {
                doFinalize = this.processFile(transformer, file, processFile);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("skip failed file : " + e.getMessage() + (e.getCause() == null ? "" : " Cause : " + e.getCause().getMessage())), (Throwable)e);
                FileState.fail.addFile(file, this.result);
                doFinalize = false;
                Object var7_6 = null;
                this.processedFiles.add(file);
                if (doFinalize) {
                    this.finalizeFile(file, processFile);
                    return;
                }
                FileUtil.deleteFile(processFile);
                return;
            }
            Object var7_5 = null;
            this.processedFiles.add(file);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.processedFiles.add(file);
            if (doFinalize) {
                this.finalizeFile(file, processFile);
                throw throwable;
            }
            FileUtil.deleteFile(processFile);
            throw throwable;
        }
        if (doFinalize) {
            this.finalizeFile(file, processFile);
            return;
        }
        FileUtil.deleteFile(processFile);
    }

    private void finalizeFile(File file, File processFile) throws IOException {
        if (this.isKeepBackup() && !this.isDryRun()) {
            File backupFile = FileUtil.getBackupFile(file);
            if (backupFile.exists()) {
                FileUtil.deleteFile(backupFile);
            }
            if (this.isVerbose()) {
                this.getLog().debug((CharSequence)(" - backup original file " + file));
            }
            FileUtil.renameFile(file, backupFile);
        }
        if (this.isDryRun()) {
            FileUtil.deleteFile(processFile);
        } else {
            try {
                FileUtil.renameFile(processFile, file);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)e.getMessage());
            }
        }
    }
}

