/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import org.codehaus.mojo.license.AbstractLicenseNameMojo;
import org.codehaus.mojo.license.model.License;
import org.codehaus.mojo.license.utils.FileUtil;

public class UpdateProjectLicenseMojo
extends AbstractLicenseNameMojo {
    protected File licenseFile;
    protected File outputDirectory;
    protected boolean generateBundle;
    protected String bundleLicensePath;
    protected boolean force;
    protected boolean skipUpdateProjectLicense;
    private boolean doGenerate;

    protected void init() throws Exception {
        if (this.isSkip()) {
            return;
        }
        super.init();
        if (this.licenseFile != null) {
            File pomFile = this.getProject().getFile();
            this.doGenerate = this.force || !this.licenseFile.exists() || this.licenseFile.lastModified() <= pomFile.lastModified();
        }
    }

    protected void doAction() throws Exception {
        License license = this.getLicense();
        if (this.doGenerate) {
            this.getLog().info((CharSequence)("Will create or update license file [" + license.getName() + "] to " + this.licenseFile));
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("detail of license :\n" + license));
            }
            if (this.licenseFile.exists() && this.isKeepBackup()) {
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("backup " + this.licenseFile));
                }
                FileUtil.backupFile(this.licenseFile);
            }
        }
        String licenseContent = license.getLicenseContent(this.getEncoding());
        if (this.doGenerate) {
            FileUtil.writeString(this.licenseFile, licenseContent, this.getEncoding());
        }
        if (this.hasClassPath()) {
            File resourceTarget = new File(this.outputDirectory, this.licenseFile.getName());
            FileUtil.copyFile(this.licenseFile, resourceTarget);
            this.addResourceDir(this.outputDirectory, "**/" + resourceTarget.getName());
            if (this.generateBundle) {
                File bundleTarget = FileUtil.getFile(this.outputDirectory, this.bundleLicensePath);
                FileUtil.copyFile(this.licenseFile, bundleTarget);
                if (!resourceTarget.getName().equals(bundleTarget.getName())) {
                    this.addResourceDir(this.outputDirectory, "**/" + bundleTarget.getName());
                }
            }
        }
    }

    public boolean isSkip() {
        return this.skipUpdateProjectLicense;
    }

    public void setSkip(boolean skip) {
        this.skipUpdateProjectLicense = skip;
    }
}

