/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.plexus.util.ReaderFactory;

public abstract class AbstractLicenseMojo
extends AbstractMojo {
    private MavenSession session;
    private MavenProject project;
    private boolean verbose;
    private String encoding;

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected abstract void init() throws Exception;

    protected abstract void doAction() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            boolean canContinue;
            if (this.getLog().isDebugEnabled()) {
                this.setVerbose(true);
            }
            if (!(canContinue = this.checkPackaging())) {
                this.getLog().warn((CharSequence)("The goal is skip due to packaging '" + this.getProject().getPackaging() + "'"));
                return;
            }
            try {
                this.checkEncoding();
                this.init();
            }
            catch (MojoFailureException e) {
                throw e;
            }
            catch (MojoExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException("could not init goal " + ((Object)((Object)this)).getClass().getSimpleName() + " for reason : " + e.getMessage(), e);
            }
            canContinue = this.checkSkip();
            if (!canContinue) {
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)"Goal will not be executed.");
                }
                return;
            }
            try {
                this.doAction();
            }
            catch (MojoFailureException e) {
                throw e;
            }
            catch (MojoExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException("could not execute goal " + ((Object)((Object)this)).getClass().getSimpleName() + " for reason : " + e.getMessage(), e);
            }
        }
        finally {
            this.afterExecute();
        }
    }

    protected void afterExecute() {
    }

    protected boolean checkPackaging() {
        return true;
    }

    protected boolean checkSkip() {
        return true;
    }

    protected boolean acceptPackaging(String ... packages) {
        String projectPackaging = this.getProject().getPackaging();
        for (String p : packages) {
            if (!p.equals(projectPackaging)) continue;
            return true;
        }
        return false;
    }

    protected boolean rejectPackaging(String ... packages) {
        String projectPackaging = this.getProject().getPackaging();
        for (String p : packages) {
            if (!p.equals(projectPackaging)) continue;
            return false;
        }
        return true;
    }

    protected void checkEncoding() {
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Will check encoding : " + this.getEncoding()));
        }
        if (StringUtils.isEmpty((String)this.getEncoding())) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            this.setEncoding(ReaderFactory.FILE_ENCODING);
        }
    }

    public final MavenProject getProject() {
        return this.project;
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public final MavenSession getSession() {
        return this.session;
    }

    public final long getBuildTimestamp() {
        return this.session.getStartTime().getTime();
    }

    protected void addResourceDir(File dir, String ... includes) {
        boolean added = MojoHelper.addResourceDir(dir, this.getProject(), includes);
        if (added && this.isVerbose()) {
            this.getLog().info((CharSequence)("add resource " + dir + " with includes " + Arrays.toString(includes)));
        }
    }

    protected boolean hasClassPath() {
        return this.rejectPackaging("pom");
    }
}

