/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.l10n;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;

public class L10NStatusReport
extends AbstractMavenReport {
    private File outputDirectory;
    private Renderer siteRenderer;
    private List locales;
    private MavenProject project;
    private List resources;
    private List excludes;
    private List includes;
    protected List reactorProjects;
    protected boolean aggregate;
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.properties"};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static /* synthetic */ Class class$org$codehaus$mojo$l10n$L10NStatusReport;

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public boolean canGenerateReport() {
        return this.canGenerateReport(this.constructResourceDirs());
    }

    protected boolean canGenerateReport(Map sourceDirs) {
        boolean canGenerate;
        boolean bl = canGenerate = !sourceDirs.isEmpty();
        if (this.aggregate && !this.project.isExecutionRoot()) {
            canGenerate = false;
        }
        return canGenerate;
    }

    protected Map constructResourceDirs() {
        HashMap sourceDirs = new HashMap();
        if (this.aggregate) {
            Iterator i = this.reactorProjects.iterator();
            while (i.hasNext()) {
                MavenProject prj = (MavenProject)i.next();
                if (prj.getResources() == null || prj.getResources().isEmpty()) continue;
                sourceDirs.put(prj, new ArrayList(prj.getResources()));
            }
        } else if (this.resources != null && !this.resources.isEmpty()) {
            sourceDirs.put(this.project, new ArrayList(this.resources));
        }
        return sourceDirs;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        TreeSet<Wrapper> included = new TreeSet<Wrapper>(new WrapperComparator());
        Map res = this.constructResourceDirs();
        Iterator it = res.keySet().iterator();
        while (it.hasNext()) {
            MavenProject prj = (MavenProject)it.next();
            List lst = (List)res.get(prj);
            Iterator i = lst.iterator();
            while (i.hasNext()) {
                Resource resource = (Resource)i.next();
                File resourceDirectory = new File(resource.getDirectory());
                if (!resourceDirectory.exists()) {
                    this.getLog().info((CharSequence)("Resource directory does not exist: " + resourceDirectory));
                    continue;
                }
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(resource.getDirectory());
                ArrayList allIncludes = new ArrayList();
                if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
                    allIncludes.addAll(resource.getIncludes());
                }
                if (this.includes != null && !this.includes.isEmpty()) {
                    allIncludes.addAll(this.includes);
                }
                if (allIncludes.isEmpty()) {
                    scanner.setIncludes(DEFAULT_INCLUDES);
                } else {
                    scanner.setIncludes(allIncludes.toArray(EMPTY_STRING_ARRAY));
                }
                ArrayList allExcludes = new ArrayList();
                if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
                    allExcludes.addAll(resource.getExcludes());
                } else if (this.excludes != null && !this.excludes.isEmpty()) {
                    allExcludes.addAll(this.excludes);
                }
                scanner.setExcludes(allExcludes.toArray(EMPTY_STRING_ARRAY));
                scanner.addDefaultExcludes();
                scanner.scan();
                List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
                Iterator<String> j = includedFiles.iterator();
                while (j.hasNext()) {
                    String name = j.next();
                    File source = new File(resource.getDirectory(), name);
                    included.add(new Wrapper(name, source, prj));
                }
            }
        }
        L10NStatusRenderer r = new L10NStatusRenderer(this.getSink(), L10NStatusReport.getBundle(locale), included);
        r.render();
    }

    public String getDescription(Locale locale) {
        return L10NStatusReport.getBundle(locale).getString("report.l10n.description");
    }

    public String getName(Locale locale) {
        return L10NStatusReport.getBundle(locale).getString("report.l10n.name");
    }

    public String getOutputName() {
        return "l10n-status";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("l10n-status-report", locale, (class$org$codehaus$mojo$l10n$L10NStatusReport == null ? (class$org$codehaus$mojo$l10n$L10NStatusReport = L10NStatusReport.class$("org.codehaus.mojo.l10n.L10NStatusReport")) : class$org$codehaus$mojo$l10n$L10NStatusReport).getClassLoader());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WrapperComparator
    implements Comparator {
        private WrapperComparator() {
        }

        public int compare(Object o1, Object o2) {
            Wrapper wr1 = (Wrapper)o1;
            Wrapper wr2 = (Wrapper)o2;
            int comp1 = wr1.getProject().getBasedir().compareTo(wr2.getProject().getBasedir());
            if (comp1 != 0) {
                return comp1;
            }
            return wr1.getFile().compareTo(wr2.getFile());
        }
    }

    private static class Wrapper {
        private String path;
        private File file;
        private MavenProject proj;
        private Map properties;
        static final String DEFAULT_LOCALE = "Default";

        public Wrapper(String p, File f, MavenProject prj) {
            this.path = p;
            this.file = f;
            this.proj = prj;
            this.properties = new HashMap();
        }

        public File getFile() {
            return this.file;
        }

        public String getPath() {
            return this.path;
        }

        public MavenProject getProject() {
            return this.proj;
        }

        public Map getProperties() {
            return this.properties;
        }
    }

    class L10NStatusRenderer
    extends AbstractMavenReportRenderer {
        private final ResourceBundle bundle;
        private Set files;
        private Pattern localedPattern = Pattern.compile(".*_[a-zA-Z]{2}[_]?[a-zA-Z]{0,2}?\\.properties");

        public L10NStatusRenderer(Sink sink, ResourceBundle bundle, Set files) {
            super(sink);
            this.bundle = bundle;
            this.files = files;
        }

        public String getTitle() {
            return this.bundle.getString("report.l10n.title");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renderBody() {
            this.startSection(this.getTitle());
            this.paragraph(this.bundle.getString("report.l10n.intro"));
            this.startSection(this.bundle.getString("report.l10n.summary"));
            this.startTable();
            this.tableCaption(this.bundle.getString("report.l10n.summary.caption"));
            String defaultLocaleColumnName = this.bundle.getString("report.l10n.column.default");
            String pathColumnName = this.bundle.getString("report.l10n.column.path");
            String missingFileLabel = this.bundle.getString("report.l10n.missingFile");
            String missingKeysLabel = this.bundle.getString("report.l10n.missingKey");
            String okLabel = this.bundle.getString("report.l10n.ok");
            String totalLabel = this.bundle.getString("report.l10n.total");
            String additionalKeysLabel = this.bundle.getString("report.l10n.additional");
            String nontranslatedKeysLabel = this.bundle.getString("report.l10n.nontranslated");
            String[] headers = new String[L10NStatusReport.this.locales != null ? L10NStatusReport.this.locales.size() + 2 : 2];
            headers[0] = pathColumnName;
            headers[1] = defaultLocaleColumnName;
            if (L10NStatusReport.this.locales != null) {
                Iterator it = L10NStatusReport.this.locales.iterator();
                int ind = 2;
                while (it.hasNext()) {
                    headers[ind] = (String)it.next();
                    ++ind;
                }
            }
            this.tableHeader(headers);
            int[] count = new int[L10NStatusReport.this.locales != null ? L10NStatusReport.this.locales.size() + 1 : 1];
            Arrays.fill(count, 0);
            Iterator it = this.files.iterator();
            MavenProject lastPrj = null;
            TreeSet<Wrapper> usedFiles = new TreeSet<Wrapper>(new WrapperComparator());
            while (it.hasNext()) {
                BufferedInputStream in;
                block29: {
                    Wrapper wr = (Wrapper)it.next();
                    if (L10NStatusReport.this.reactorProjects.size() > 1 && (lastPrj == null || lastPrj != wr.getProject())) {
                        lastPrj = wr.getProject();
                        this.sink.tableRow();
                        String name = wr.getProject().getName();
                        if (name == null) {
                            name = wr.getProject().getGroupId() + ":" + wr.getProject().getArtifactId();
                        }
                        this.tableCell("<b><i>" + name + "</b></i>", true);
                        this.sink.tableRow_();
                    }
                    if (!wr.getFile().getName().endsWith(".properties") || this.localedPattern.matcher(wr.getFile().getName()).matches()) continue;
                    usedFiles.add(wr);
                    this.sink.tableRow();
                    this.tableCell(wr.getPath());
                    Properties props = new Properties();
                    in = null;
                    try {
                        in = new BufferedInputStream(new FileInputStream(wr.getFile()));
                        props.load(in);
                        wr.getProperties().put("Default", props);
                        this.tableCell("" + ((Hashtable)props).size(), true);
                        count[0] = count[0] + ((Hashtable)props).size();
                        if (L10NStatusReport.this.locales == null) break block29;
                        Iterator it2 = L10NStatusReport.this.locales.iterator();
                        int i = 1;
                        while (it2.hasNext()) {
                            block31: {
                                block30: {
                                    String loc = (String)it2.next();
                                    String nm = wr.getFile().getName();
                                    String fn = nm.substring(0, nm.length() - ".properties".length());
                                    File locFile = new File(wr.getFile().getParentFile(), fn + "_" + loc + ".properties");
                                    if (!locFile.exists()) break block30;
                                    BufferedInputStream in2 = null;
                                    Properties props2 = new Properties();
                                    try {
                                        in2 = new BufferedInputStream(new FileInputStream(locFile));
                                        props2.load(in2);
                                        wr.getProperties().put(loc, props2);
                                        HashSet missing = new HashSet(((Hashtable)props).keySet());
                                        missing.removeAll(((Hashtable)props2).keySet());
                                        HashSet additional = new HashSet(((Hashtable)props2).keySet());
                                        additional.removeAll(((Hashtable)props).keySet());
                                        HashSet<String> nonTranslated = new HashSet<String>();
                                        Iterator itx = ((Hashtable)props).keySet().iterator();
                                        while (itx.hasNext()) {
                                            String k = (String)itx.next();
                                            String val1 = props.getProperty(k);
                                            String val2 = props2.getProperty(k);
                                            if (val2 == null || !val1.equals(val2)) continue;
                                            nonTranslated.add(k);
                                        }
                                        count[i] = count[i] + (((Hashtable)props).size() - missing.size() - nonTranslated.size());
                                        StringBuffer statusRows = new StringBuffer();
                                        if (missing.size() != 0) {
                                            statusRows.append("<tr><td>" + missingKeysLabel + "</td><td><b>" + missing.size() + "</b></td></tr>");
                                        } else {
                                            statusRows.append("<tr><td>&nbsp;</td><td>&nbsp;</td></tr>");
                                        }
                                        if (additional.size() != 0) {
                                            statusRows.append("<tr><td>" + additionalKeysLabel + "</td><td><b>" + additional.size() + "</b></td></tr>");
                                        } else {
                                            statusRows.append("<tr><td>&nbsp;</td><td>&nbsp;</td></tr>");
                                        }
                                        if (nonTranslated.size() != 0) {
                                            statusRows.append("<tr><td>" + nontranslatedKeysLabel + "</td><td><b>" + nonTranslated.size() + "</b></td></tr>");
                                        }
                                        this.tableCell(this.wrapInTable(okLabel, statusRows.toString()), true);
                                    }
                                    catch (Throwable throwable) {
                                        IOUtil.close(in2);
                                        throw throwable;
                                    }
                                    IOUtil.close((InputStream)in2);
                                    break block31;
                                }
                                this.tableCell(missingFileLabel);
                                count[i] = count[i] + 0;
                            }
                            ++i;
                        }
                    }
                    catch (IOException ex) {
                        try {
                            L10NStatusReport.this.getLog().error((Throwable)ex);
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(in);
                            throw throwable;
                        }
                        IOUtil.close((InputStream)in);
                    }
                }
                IOUtil.close((InputStream)in);
                this.sink.tableRow_();
            }
            this.sink.tableRow();
            this.tableCell(totalLabel);
            for (int i = 0; i < count.length; ++i) {
                if (i != 0 && count[0] != 0) {
                    this.tableCell("<b>" + count[i] + "</b><br />(" + count[i] * 100 / count[0] + "&nbsp;%)", true);
                    continue;
                }
                if (i != 0) continue;
                this.tableCell("<b>" + count[i] + "</b>", true);
            }
            this.sink.tableRow_();
            this.endTable();
            L10NStatusReport.this.getSink().paragraph();
            this.text(this.bundle.getString("report.l10n.legend"));
            L10NStatusReport.this.getSink().paragraph_();
            L10NStatusReport.this.getSink().list();
            L10NStatusReport.this.getSink().listItem();
            this.text(this.bundle.getString("report.l10n.list1"));
            L10NStatusReport.this.getSink().listItem_();
            L10NStatusReport.this.getSink().listItem();
            this.text(this.bundle.getString("report.l10n.list2"));
            L10NStatusReport.this.getSink().listItem_();
            L10NStatusReport.this.getSink().listItem();
            this.text(this.bundle.getString("report.l10n.list3"));
            L10NStatusReport.this.getSink().listItem_();
            L10NStatusReport.this.getSink().list_();
            L10NStatusReport.this.getSink().paragraph();
            this.text(this.bundle.getString("report.l10n.note"));
            L10NStatusReport.this.getSink().paragraph_();
            this.endSection();
            if (L10NStatusReport.this.locales != null) {
                String x;
                Iterator itx = L10NStatusReport.this.locales.iterator();
                L10NStatusReport.this.getSink().list();
                while (itx.hasNext()) {
                    x = (String)itx.next();
                    L10NStatusReport.this.getSink().listItem();
                    this.link("#" + x, x);
                    L10NStatusReport.this.getSink().listItem_();
                }
                L10NStatusReport.this.getSink().list_();
                itx = L10NStatusReport.this.locales.iterator();
                while (itx.hasNext()) {
                    x = (String)itx.next();
                    L10NStatusReport.this.getSink().anchor(x);
                    this.startSection(x);
                    this.startTable();
                    this.tableCaption(this.bundle.getString("report.l10n.locale") + " " + x);
                    this.tableHeader(new String[]{this.bundle.getString("report.l10n.tableheader1"), this.bundle.getString("report.l10n.tableheader2"), this.bundle.getString("report.l10n.tableheader3"), this.bundle.getString("report.l10n.tableheader4")});
                    Iterator usedIter = usedFiles.iterator();
                    while (usedIter.hasNext()) {
                        this.sink.tableRow();
                        Wrapper wr = (Wrapper)usedIter.next();
                        this.tableCell(wr.getPath());
                        Properties defs = (Properties)wr.getProperties().get("Default");
                        Properties locals = (Properties)wr.getProperties().get(x);
                        if (locals == null) {
                            locals = new Properties();
                        }
                        TreeSet missing = new TreeSet(((Hashtable)defs).keySet());
                        missing.removeAll(((Hashtable)locals).keySet());
                        String cell = "";
                        Iterator ms = missing.iterator();
                        while (ms.hasNext()) {
                            cell = cell + "<tr><td>" + ms.next() + "</td></tr>";
                        }
                        this.tableCell(this.wrapInTable(okLabel, cell), true);
                        TreeSet additional = new TreeSet(((Hashtable)locals).keySet());
                        additional.removeAll(((Hashtable)defs).keySet());
                        Iterator ex = additional.iterator();
                        cell = "";
                        while (ex.hasNext()) {
                            cell = cell + "<tr><td>" + ex.next() + "</td></tr>";
                        }
                        this.tableCell(this.wrapInTable(okLabel, cell), true);
                        TreeSet<String> nonTranslated = new TreeSet<String>();
                        Iterator itnt = ((Hashtable)defs).keySet().iterator();
                        while (itnt.hasNext()) {
                            String k = (String)itnt.next();
                            String val1 = defs.getProperty(k);
                            String val2 = locals.getProperty(k);
                            if (val2 == null || !val1.equals(val2)) continue;
                            nonTranslated.add(k);
                        }
                        Iterator nt = nonTranslated.iterator();
                        cell = "";
                        while (nt.hasNext()) {
                            String n = (String)nt.next();
                            cell = cell + "<tr><td>" + n + "</td><td>\"" + defs.getProperty(n) + "\"</td></tr>";
                        }
                        this.tableCell(this.wrapInTable(okLabel, cell), true);
                        this.sink.tableRow_();
                    }
                    this.endTable();
                    this.endSection();
                }
            }
            this.endSection();
        }

        private String wrapInTable(String okLabel, String cell) {
            cell = cell.length() == 0 ? okLabel : "<table><tbody>" + cell + "</tbody></table>";
            return cell;
        }
    }
}

