/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.cli.Commandline;
import org.codehaus.mojo.keytool.AbstractKeyToolRequestWithKeyStoreAndAliasParametersMojo;
import org.codehaus.mojo.keytool.requests.KeyToolGenerateKeyPairRequest;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="generateKeyPair", requiresProject=true)
public class GenerateKeyPairMojo
extends AbstractKeyToolRequestWithKeyStoreAndAliasParametersMojo<KeyToolGenerateKeyPairRequest> {
    @Parameter
    private String keyalg;
    @Parameter
    private String keysize;
    @Parameter
    private String keypass;
    @Parameter
    private String sigalg;
    @Parameter
    private String validity;
    @Parameter
    private String startdate;
    @Parameter
    private String ext;
    @Parameter
    private String dname;
    @Parameter
    private boolean skipIfExist;

    public GenerateKeyPairMojo() {
        super(KeyToolGenerateKeyPairRequest.class);
    }

    @Override
    public void execute() throws MojoExecutionException {
        File keystoreFile;
        boolean keystoreFileExists;
        if (this.skipIfExist && (keystoreFileExists = (keystoreFile = this.getKeystoreFile()).exists())) {
            this.getLog().info((CharSequence)("Skip execution, keystore already exists at " + keystoreFile));
            this.setSkip(true);
        }
        super.execute();
    }

    @Override
    protected KeyToolGenerateKeyPairRequest createKeytoolRequest() {
        KeyToolGenerateKeyPairRequest request = (KeyToolGenerateKeyPairRequest)super.createKeytoolRequest();
        request.setKeyalg(this.keyalg);
        request.setKeysize(this.keysize);
        request.setKeypass(this.keypass);
        request.setSigalg(this.sigalg);
        request.setDname(this.dname);
        request.setStartdate(this.startdate);
        request.setExt(this.ext);
        request.setValidity(this.validity);
        return request;
    }

    @Override
    protected String getCommandlineInfo(Commandline commandLine) {
        String commandLineInfo = super.getCommandlineInfo(commandLine);
        commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.keypass, (String)"'*****'");
        return commandLineInfo;
    }
}

