/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.shared.utils.cli.javatool.AbstractJavaTool;
import org.apache.maven.shared.utils.cli.javatool.JavaToolException;
import org.codehaus.mojo.keytool.CommandLineConfigurationException;
import org.codehaus.mojo.keytool.KeyTool;
import org.codehaus.mojo.keytool.KeyToolCommandLineBuilder;
import org.codehaus.mojo.keytool.KeyToolRequest;
import org.codehaus.mojo.keytool.UnsupportedKeyToolRequestException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=KeyTool.class, hint="default")
public class DefaultKeyTool
extends AbstractJavaTool<KeyToolRequest>
implements KeyTool {
    @Requirement
    protected KeyToolCommandLineBuilder builder;

    public DefaultKeyTool() {
        super("keytool");
    }

    protected Commandline createCommandLine(KeyToolRequest request, String javaToolFile) throws JavaToolException {
        Commandline cli;
        this.builder.setLogger(this.getLogger());
        this.builder.setKeyToolFile(javaToolFile);
        try {
            cli = this.builder.build(request);
        }
        catch (CommandLineConfigurationException | UnsupportedKeyToolRequestException e) {
            throw new JavaToolException("Error configuring command-line. Reason: " + ((Throwable)e).getMessage(), (Throwable)e);
        }
        if (request.isVerbose()) {
            this.getLogger().info(cli.toString());
        } else {
            this.getLogger().debug(cli.toString());
        }
        return cli;
    }

    protected StreamConsumer createSystemOutStreamConsumer(KeyToolRequest request) {
        StreamConsumer systemOut = request.getSystemOutStreamConsumer();
        if (systemOut == null) {
            final boolean verbose = request.isVerbose();
            systemOut = new StreamConsumer(){

                public void consumeLine(String line) {
                    if (verbose) {
                        DefaultKeyTool.this.getLogger().info(line);
                    } else {
                        DefaultKeyTool.this.getLogger().debug(line);
                    }
                }
            };
        }
        return systemOut;
    }
}

