package org.codehaus.mojo.jslint;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on jslint-maven-plugin.<br/> Call <pre>  mvn jslint:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Tue Sep 13 08:49:50 EST 2011
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.7)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:jslint-maven-plugin:1.0.0", 0 );
        append( sb, "", 0 );

        append( sb, "JSLint Maven Plugin", 0 );
        append( sb, "Provides JSLint capabilities.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 3 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "jslint:help", 0 );
            append( sb, "Display help information on jslint-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jslint:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jslint".equals( goal ) )
        {
            append( sb, "jslint:jslint", 0 );
            append( sb, "Goal which reports on the source files using JSLint.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "adsafe (Default: false)", 2 );
                append( sb, "true if ADsafe rules should be enforced. @see http://www.ADsafe.org/.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "allowOneVarStatementPerFunction (Default: true)", 2 );
                append( sb, "true if only one var statement per function should be allowed. @see http://www.jslint.com/lint.html#scope", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "assumeABrowser (Default: true)", 2 );
                append( sb, "true if the standard browser globals should be predefined. @see http://www.jslint.com/lint.html#browser", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "assumeAYahooWidget (Default: false)", 2 );
                append( sb, "true if the Yahoo Widgets globals should be predefined. @see http://www.jslint.com/lint.html#widget", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "assumeConsoleAlertEtc (Default: false)", 2 );
                append( sb, "true if browser globals that are useful in development should be predefined. @see morehttp://www.jslint.com/lint.html#devel", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "assumeRhino (Default: false)", 2 );
                append( sb, "true if the Rhino environment globals should be predefined. @see http://www.jslint.com/lint.html#rhino", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "assumeWindows (Default: false)", 2 );
                append( sb, "true if the Windows globals should be predefined. @see http://www.jslint.com/lint.html#windows", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "disallowBitwiseOperators (Default: true)", 2 );
                append( sb, "true if bitwise operators should not be allowed. @see http://www.jslint.com/lint.html#bitwise", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "disallowDanglingUnderbarInIdentifiers (Default: false)", 2 );
                append( sb, "true if names should be checked for initial or trailing underbars.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "disallowIncrAndDecr (Default: false)", 2 );
                append( sb, "true if ++ and -- should not be allowed. @see http://www.jslint.com/lint.html#inc", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "disallowInsecureCharsInRegExp (Default: true)", 2 );
                append( sb, "true if . and [^...] should not be allowed in RegExp literals. These forms should not be used when validating in secure applications.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "disallowUndefinedVariables (Default: true)", 2 );
                append( sb, "true if variables must be declared before used. @see http://www.jslint.com/lint.html#undefined", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Files to exclude. Nothing is excluded by default.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnIssues (Default: true)", 2 );
                append( sb, "Stop the build if things go wrong according to JSLint.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "Files to include. Defaults to \'**\\/*.js\'.", 3 );
                append( sb, "", 0 );

                append( sb, "maximumLengthOfLine", 2 );
                append( sb, "The maximum length of a source line.", 3 );
                append( sb, "", 0 );

                append( sb, "maximumNumberOfErrors (Default: 50)", 2 );
                append( sb, "The maximum number of warnings reported.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "predefinedVars (Default: false)", 2 );
                append( sb, "An array of strings, the names of predefined global variables. predef is used with the option object, but not with the jslint comment. Use the var statement to declare global variables in a script file.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "requireInitialCapsForConstructors (Default: true)", 2 );
                append( sb, "true if Initial Caps must be used with constructor functions. @see http://www.jslint.com/lint.html#new", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "requireUseStrict (Default: false)", 2 );
                append( sb, "true if the ES5 \'use strict\'; pragma is required. Do not use this option carelessly.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "safeSubset (Default: false)", 2 );
                append( sb, "true if the safe subset rules are enforced. These rules are used by ADsafe. It enforces the safe subset rules but not the widget structure rules.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "sourceJsFolder (Default: ${basedir}/src/main/js)", 2 );
                append( sb, "The source JavaScript folder.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "stopOnFirstError (Default: false)", 2 );
                append( sb, "true if the scan should stop on first error.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "strictWhiteSpace (Default: false)", 2 );
                append( sb, "true if the ES5 \'use strict\'; pragma is required. Do not use this option carelessly.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "strictWhiteSpaceIndentation (Default: 4)", 2 );
                append( sb, "The number of spaces used for indentation.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateContinuation (Default: false)", 2 );
                append( sb, "true if the continuation statement should be tolerated.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateCSSWorkarounds (Default: false)", 2 );
                append( sb, "true if CSS workarounds should be tolerated. @see http://www.jslint.com/lint.html#css", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateDebuggerStatements (Default: false)", 2 );
                append( sb, "true if debugger statements should be allowed. Set this option to false before going into production.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateES5Syntax (Default: false)", 2 );
                append( sb, "true if ES5 syntax should be allowed.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateEval (Default: false)", 2 );
                append( sb, "true if eval should be allowed. @see http://www.jslint.com/lint.html#evil", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateHTMLCase (Default: false)", 2 );
                append( sb, "true if upper case HTML should be allowed.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateHTMLEventHandlers (Default: false)", 2 );
                append( sb, "true if HTML event handlers should be allowed. @see http://www.jslint.com/lint.html#html", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateHTMLFragments (Default: false)", 2 );
                append( sb, "true if HTML fragments should be allowed. @see http://www.jslint.com/lint.html#html", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateInefficientSubscripting (Default: false)", 2 );
                append( sb, "true if subscript notation may be used for expressions better expressed in dot notation.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateUnfilteredForIn (Default: true)", 2 );
                append( sb, "true if unfiltered for in statements should be allowed. @see http://www.jslint.com/lint.html#forin", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "workFolder (Default: ${project.build.directory}/JSLintMojo/main)", 2 );
                append( sb, "The folder where files are created that assist with multiple invocations e.g. incremental builds.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test-jslint".equals( goal ) )
        {
            append( sb, "jslint:test-jslint", 0 );
            append( sb, "Goal which reports on the test source files using JSLint.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "adsafe (Default: false)", 2 );
                append( sb, "true if ADsafe rules should be enforced. @see http://www.ADsafe.org/.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "allowOneVarStatementPerFunction (Default: true)", 2 );
                append( sb, "true if only one var statement per function should be allowed. @see http://www.jslint.com/lint.html#scope", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "assumeABrowser (Default: true)", 2 );
                append( sb, "true if the standard browser globals should be predefined. @see http://www.jslint.com/lint.html#browser", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "assumeAYahooWidget (Default: false)", 2 );
                append( sb, "true if the Yahoo Widgets globals should be predefined. @see http://www.jslint.com/lint.html#widget", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "assumeConsoleAlertEtc (Default: false)", 2 );
                append( sb, "true if browser globals that are useful in development should be predefined. @see morehttp://www.jslint.com/lint.html#devel", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "assumeRhino (Default: false)", 2 );
                append( sb, "true if the Rhino environment globals should be predefined. @see http://www.jslint.com/lint.html#rhino", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "assumeWindows (Default: false)", 2 );
                append( sb, "true if the Windows globals should be predefined. @see http://www.jslint.com/lint.html#windows", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "disallowBitwiseOperators (Default: true)", 2 );
                append( sb, "true if bitwise operators should not be allowed. @see http://www.jslint.com/lint.html#bitwise", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "disallowDanglingUnderbarInIdentifiers (Default: false)", 2 );
                append( sb, "true if names should be checked for initial or trailing underbars.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "disallowIncrAndDecr (Default: false)", 2 );
                append( sb, "true if ++ and -- should not be allowed. @see http://www.jslint.com/lint.html#inc", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "disallowInsecureCharsInRegExp (Default: true)", 2 );
                append( sb, "true if . and [^...] should not be allowed in RegExp literals. These forms should not be used when validating in secure applications.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "disallowUndefinedVariables (Default: true)", 2 );
                append( sb, "true if variables must be declared before used. @see http://www.jslint.com/lint.html#undefined", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Files to exclude. Nothing is excluded by default.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnIssues (Default: true)", 2 );
                append( sb, "Stop the build if things go wrong according to JSLint.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "Files to include. Defaults to \'**\\/*.js\'.", 3 );
                append( sb, "", 0 );

                append( sb, "maximumLengthOfLine", 2 );
                append( sb, "The maximum length of a source line.", 3 );
                append( sb, "", 0 );

                append( sb, "maximumNumberOfErrors (Default: 50)", 2 );
                append( sb, "The maximum number of warnings reported.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "predefinedVars (Default: false)", 2 );
                append( sb, "An array of strings, the names of predefined global variables. predef is used with the option object, but not with the jslint comment. Use the var statement to declare global variables in a script file.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "requireInitialCapsForConstructors (Default: true)", 2 );
                append( sb, "true if Initial Caps must be used with constructor functions. @see http://www.jslint.com/lint.html#new", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "requireUseStrict (Default: false)", 2 );
                append( sb, "true if the ES5 \'use strict\'; pragma is required. Do not use this option carelessly.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "safeSubset (Default: false)", 2 );
                append( sb, "true if the safe subset rules are enforced. These rules are used by ADsafe. It enforces the safe subset rules but not the widget structure rules.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "sourceJsFolder (Default: ${basedir}/src/test/js)", 2 );
                append( sb, "The JavaScript test source folder.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "stopOnFirstError (Default: false)", 2 );
                append( sb, "true if the scan should stop on first error.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "strictWhiteSpace (Default: false)", 2 );
                append( sb, "true if the ES5 \'use strict\'; pragma is required. Do not use this option carelessly.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "strictWhiteSpaceIndentation (Default: 4)", 2 );
                append( sb, "The number of spaces used for indentation.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateContinuation (Default: false)", 2 );
                append( sb, "true if the continuation statement should be tolerated.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateCSSWorkarounds (Default: false)", 2 );
                append( sb, "true if CSS workarounds should be tolerated. @see http://www.jslint.com/lint.html#css", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateDebuggerStatements (Default: false)", 2 );
                append( sb, "true if debugger statements should be allowed. Set this option to false before going into production.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateES5Syntax (Default: false)", 2 );
                append( sb, "true if ES5 syntax should be allowed.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateEval (Default: false)", 2 );
                append( sb, "true if eval should be allowed. @see http://www.jslint.com/lint.html#evil", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateHTMLCase (Default: false)", 2 );
                append( sb, "true if upper case HTML should be allowed.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateHTMLEventHandlers (Default: false)", 2 );
                append( sb, "true if HTML event handlers should be allowed. @see http://www.jslint.com/lint.html#html", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateHTMLFragments (Default: false)", 2 );
                append( sb, "true if HTML fragments should be allowed. @see http://www.jslint.com/lint.html#html", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateInefficientSubscripting (Default: false)", 2 );
                append( sb, "true if subscript notation may be used for expressions better expressed in dot notation.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "tolerateUnfilteredForIn (Default: true)", 2 );
                append( sb, "true if unfiltered for in statements should be allowed. @see http://www.jslint.com/lint.html#forin", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "workFolder (Default: ${project.build.directory}/JSLintMojo/test)", 2 );
                append( sb, "The folder where files are created that assist with multiple invocations e.g. incremental builds.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
