/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jsimport;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.mojo.jsimport.FileCollector;
import org.codehaus.mojo.jsimport.FileDependencyPersistanceUtil;
import org.codehaus.mojo.jsimport.LocalRepositoryCollector;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenerateHtmlMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenSession session;
    private ArtifactRepository localRepository;
    private List<String> includes;
    private List<String> excludes;
    private String targetJsPath;
    private String encoding;
    private BuildContext buildContext;
    private MavenFileFilter mavenFileFilter;
    private final Map<String, LinkedHashSet<String>> fileDependencies = new HashMap<String, LinkedHashSet<String>>();
    private final Map<String, LinkedHashSet<String>> compileFileDependencies = new HashMap<String, LinkedHashSet<String>>();

    private String buildImportsRecursively(Set<String> visitedNodes, LinkedHashSet<String> filePaths, LinkedHashSet<String> allImports) {
        String cyclicFilePath = null;
        for (String filePath : filePaths) {
            if (visitedNodes.contains(filePath)) continue;
            visitedNodes.add(filePath);
            LinkedHashSet<String> filePathDependencies = this.fileDependencies.get(filePath);
            if (filePathDependencies == null && this.compileFileDependencies != null) {
                filePathDependencies = this.compileFileDependencies.get(filePath);
            }
            if (filePathDependencies != null) {
                cyclicFilePath = this.buildImportsRecursively(visitedNodes, filePathDependencies, allImports);
            } else if (allImports.contains(filePath)) {
                cyclicFilePath = filePath;
            }
            if (cyclicFilePath != null) break;
            allImports.add(filePath);
        }
        return cyclicFilePath;
    }

    private void copyLocalRepoFilesToTarget(Map<String, String> localRepoFilesToCopy, File targetFolder) throws MojoExecutionException {
        for (Map.Entry<String, String> entry : localRepoFilesToCopy.entrySet()) {
            try {
                File sourceFile = new File(entry.getKey());
                File targetFile = new File(targetFolder, entry.getValue());
                if (sourceFile.lastModified() <= targetFile.lastModified()) continue;
                FileUtils.copyFile((File)sourceFile, (File)targetFile);
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Copying file: " + sourceFile.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("While copying files: ", (Exception)e);
            }
        }
    }

    public void doExecute(File sourceJsFolder, File mainSourceJsFolder, File htmlResourceFolder, File targetFolder, File mainTargetFolder, File workFolder, Scope scope) throws MojoExecutionException {
        long mainFileDependencyGraphModificationTime;
        File mainWorkFolder;
        HashMap<String, String> fileAssignedGlobals = new HashMap<String, String>();
        long fileDependencyGraphModificationTime = FileDependencyPersistanceUtil.readFileDependencyGraph(workFolder, this.fileDependencies, fileAssignedGlobals);
        if (scope == Scope.TEST) {
            mainWorkFolder = new File(workFolder.getParentFile(), "main");
            HashMap<String, String> compileFileAssignedGlobals = new HashMap<String, String>();
            mainFileDependencyGraphModificationTime = FileDependencyPersistanceUtil.readFileDependencyGraph(mainWorkFolder, this.compileFileDependencies, compileFileAssignedGlobals);
        } else {
            mainWorkFolder = workFolder;
            mainFileDependencyGraphModificationTime = fileDependencyGraphModificationTime;
        }
        HashMap<String, String> localRepoFilesToCopy = new HashMap<String, String>();
        HashMap<String, String> mainLocalRepoFilesToCopy = new HashMap<String, String>();
        Properties fileDependencyProperties = this.generateProperties(sourceJsFolder, mainSourceJsFolder, workFolder, mainWorkFolder, localRepoFilesToCopy, mainLocalRepoFilesToCopy);
        this.copyLocalRepoFilesToTarget(localRepoFilesToCopy, targetFolder);
        if (scope == Scope.TEST) {
            this.copyLocalRepoFilesToTarget(mainLocalRepoFilesToCopy, mainTargetFolder);
        }
        this.generateHtmlWithProperties(fileDependencyProperties, fileDependencyGraphModificationTime, mainFileDependencyGraphModificationTime, htmlResourceFolder, targetFolder);
    }

    private void generateHtmlWithProperties(Properties fileDependencyProperties, long fileDependencyGraphModificationTime, long mainFileDependencyGraphModificationTime, File htmlResourceFolder, File targetFolder) {
        FileCollector fileCollector = new FileCollector(this.buildContext, new String[]{"**/*.html", "**/*.htm"}, new String[0]);
        List<String> includedFiles = fileCollector.collectPaths(htmlResourceFolder, this.includes, this.excludes);
        boolean htmlFilesFiltered = false;
        int lastNestedFolderCount = -1;
        MavenFileFilterRequest filterRequest = new MavenFileFilterRequest();
        filterRequest.setMavenProject(this.project);
        filterRequest.setMavenSession(this.session);
        filterRequest.setFiltering(true);
        for (String resourceFile : includedFiles) {
            int nestedFolderCount;
            File destinationFile = new File(targetFolder, resourceFile);
            File sourceFile = new File(htmlResourceFolder, resourceFile);
            if (!htmlFilesFiltered && sourceFile.lastModified() <= destinationFile.lastModified() && destinationFile.lastModified() >= fileDependencyGraphModificationTime && destinationFile.lastModified() >= mainFileDependencyGraphModificationTime) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Applying import filter to: " + resourceFile));
            }
            if ((nestedFolderCount = StringUtils.countMatches((String)resourceFile, (String)File.separator)) != lastNestedFolderCount) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < nestedFolderCount; ++i) {
                    sb.append("../");
                }
                String relativePath = sb.toString();
                Properties relativeFileDependencyProperties = new Properties();
                for (Map.Entry<Object, Object> keyValue : fileDependencyProperties.entrySet()) {
                    relativeFileDependencyProperties.put(keyValue.getKey(), relativePath + ((String)keyValue.getValue()).replaceAll("src=\"", "src=\"" + relativePath));
                }
                filterRequest.setAdditionalProperties(relativeFileDependencyProperties);
                lastNestedFolderCount = nestedFolderCount;
            }
            filterRequest.setFrom(sourceFile);
            destinationFile.getParentFile().mkdirs();
            filterRequest.setTo(destinationFile);
            try {
                this.mavenFileFilter.copyFile(filterRequest);
                this.buildContext.refresh(destinationFile);
                htmlFilesFiltered = true;
            }
            catch (MavenFilteringException e) {
                this.getLog().error((Throwable)e);
            }
        }
        if (htmlFilesFiltered) {
            this.getLog().info((CharSequence)("Dependencies changed. " + includedFiles.size() + " file(s) re-filtered."));
        }
    }

    private Properties generateProperties(File sourceJsFolder, File mainSourceJsFolder, File workFolder, File mainWorkFolder, Map<String, String> localRepoFilesToCopy, Map<String, String> mainLocalRepoFilesToCopy) throws MojoExecutionException {
        Properties fileDependencyProperties = new Properties();
        String sourceFolderPath = sourceJsFolder.getAbsolutePath();
        if (sourceFolderPath.length() == 0) {
            return fileDependencyProperties;
        }
        String mainSourceFolderPath = mainSourceJsFolder.getAbsolutePath();
        if (mainSourceFolderPath.length() == 0) {
            return fileDependencyProperties;
        }
        LocalRepositoryCollector localRepositoryCollector = new LocalRepositoryCollector(this.project, this.localRepository, new File[]{new File(workFolder, "www-zip"), new File(mainWorkFolder, "www-zip")});
        for (Map.Entry<String, LinkedHashSet<String>> entry : this.fileDependencies.entrySet()) {
            String jsFile = entry.getKey();
            if (!jsFile.startsWith(sourceFolderPath)) continue;
            HashSet<String> visitedNodes = new HashSet<String>();
            LinkedHashSet<String> allImports = new LinkedHashSet<String>();
            String cyclicFilePath = this.buildImportsRecursively(visitedNodes, entry.getValue(), allImports);
            if (cyclicFilePath == null && allImports.contains(jsFile)) {
                cyclicFilePath = jsFile;
            }
            String closeOpenScriptDeclaration = "\"></script>\n<script type=\"text/javascript\" src=\"";
            StringBuilder propertyValue = new StringBuilder();
            for (String importFile : allImports) {
                String relativeImportFile;
                if (importFile.startsWith(sourceFolderPath)) {
                    relativeImportFile = this.targetJsPath + importFile.substring(sourceFolderPath.length());
                } else if (importFile.startsWith(mainSourceFolderPath)) {
                    relativeImportFile = this.targetJsPath + importFile.substring(mainSourceFolderPath.length());
                } else {
                    String localRepositoryPath = localRepositoryCollector.findLocalRepository(importFile);
                    if (localRepositoryPath != null) {
                        relativeImportFile = this.targetJsPath + importFile.substring(localRepositoryPath.length());
                        if (this.compileFileDependencies == null || this.compileFileDependencies != null && !this.compileFileDependencies.containsKey(importFile)) {
                            localRepoFilesToCopy.put(importFile, relativeImportFile);
                        } else {
                            mainLocalRepoFilesToCopy.put(importFile, relativeImportFile);
                        }
                    } else {
                        throw new MojoExecutionException("Unexpected import file path (not project relative or local repo): " + importFile);
                    }
                }
                if (importFile.equals(cyclicFilePath)) {
                    throw new MojoExecutionException("Cyclic reference found in: " + relativeImportFile);
                }
                if (propertyValue.length() > 0) {
                    propertyValue.append(closeOpenScriptDeclaration);
                }
                propertyValue.append(relativeImportFile);
            }
            if (propertyValue.length() > 0) {
                propertyValue.append(closeOpenScriptDeclaration);
            }
            String propertyName = sourceFolderPath.length() > 1 ? jsFile.substring(sourceFolderPath.length() + 1) : jsFile;
            String normalisedPropertyName = propertyName.replace(File.separatorChar, '/');
            String normalisedPropertyValue = propertyValue.append(this.targetJsPath + "/" + normalisedPropertyName).toString().replace(File.separatorChar, '/');
            fileDependencyProperties.setProperty(normalisedPropertyName, normalisedPropertyValue);
            if (!this.getLog().isDebugEnabled()) continue;
            this.getLog().debug((CharSequence)("Generating script statements for files: " + allImports + " relating to filter property: " + normalisedPropertyName));
        }
        return fileDependencyProperties;
    }

    public BuildContext getBuildContext() {
        return this.buildContext;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public Map<String, LinkedHashSet<String>> getFileDependencies() {
        return this.fileDependencies;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public MavenFileFilter getMavenFileFilter() {
        return this.mavenFileFilter;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public String getTargetJsPath() {
        return this.targetJsPath;
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public void setMavenFileFilter(MavenFileFilter mavenFileFilter) {
        this.mavenFileFilter = mavenFileFilter;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public void setTargetJsPath(String targetJsPath) {
        this.targetJsPath = targetJsPath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Scope {
        COMPILE,
        TEST;

    }
}

