/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.jboss.AbstractJBossServerMojo;

public class HardDeployMojo
extends AbstractJBossServerMojo {
    protected File[] fileNames;
    protected File fileName;
    protected String deploySubDir;
    protected boolean unpack;

    public void execute() throws MojoExecutionException {
        this.checkConfig();
        if (this.fileNames == null || this.fileNames.length == 0) {
            this.fileNames = new File[1];
            this.fileNames[0] = this.fileName;
        }
        for (int i = 0; i < this.fileNames.length; ++i) {
            try {
                String nextFileName = this.fileNames[i].getAbsolutePath();
                String fixedFile = null;
                fixedFile = nextFileName.toLowerCase().endsWith("ejb") ? nextFileName.substring(0, nextFileName.length() - 3) + "jar" : nextFileName;
                String deployDir = this.deploySubDir == null ? "/deploy/" : "/deploy/" + this.deploySubDir + "/";
                File src = new File(fixedFile);
                File dst = new File(this.jbossHome + "/server/" + this.serverName + deployDir + src.getName());
                this.getLog().info((CharSequence)((this.unpack ? "Unpacking " : "Copying ") + src.getAbsolutePath() + " to " + dst.getAbsolutePath()));
                this.copy(src, dst);
                continue;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Mojo error occurred: " + e.getMessage(), e);
            }
        }
    }

    private void copy(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                this.copy(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            this.copyFile(srcDir, dstDir);
        }
    }

    private void copyFile(File src, File dst) throws IOException {
        if (this.unpack) {
            this.unpack(src, dst);
        } else {
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            this.streamcopy(in, out);
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    private void streamcopy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    public void unpack(File zipFile, File targetDir) throws IOException {
        ZipEntry entry;
        FileInputStream in = new FileInputStream(zipFile);
        ZipInputStream zipIn = new ZipInputStream(in);
        File dir = targetDir.getCanonicalFile();
        dir.mkdirs();
        while ((entry = zipIn.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            String file = targetDir + "/" + entry.getName();
            new File(file).getParentFile().getCanonicalFile().mkdirs();
            FileOutputStream out = new FileOutputStream(file);
            this.streamcopy(zipIn, out);
            out.close();
        }
        zipIn.close();
    }
}

