/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxws;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Invoker {
    public static void main(String ... args) throws Exception {
        Throwable throwable;
        String toolClassname = args[0];
        int idx = 1;
        String cp = args[2];
        if ("-pathfile".equals(args[1])) {
            File pathFile = new File(args[2]);
            pathFile.deleteOnExit();
            Properties p = new Properties();
            throwable = null;
            try (FileInputStream is = new FileInputStream(pathFile);){
                p.load(is);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            cp = p.getProperty("cp");
            idx = 3;
        }
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        String origJcp = System.getProperty("java.class.path");
        try {
            throwable = null;
            try (URLClassLoader cl = new URLClassLoader(Invoker.toUrls(cp));){
                Thread.currentThread().setContextClassLoader(cl);
                System.setProperty("java.class.path", cp);
                Class<?> toolClass = cl.loadClass(toolClassname);
                Object tool = toolClass.getConstructor(OutputStream.class).newInstance(System.out);
                Method runMethod = toolClass.getMethod("run", String[].class);
                String[] wsargs = new String[args.length - idx];
                System.arraycopy(args, idx, wsargs, 0, args.length - idx);
                System.exit((Boolean)runMethod.invoke(tool, new Object[]{wsargs}) != false ? 0 : 1);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (NoSuchMethodException ex) {
            Invoker.logSevere(ex);
        }
        catch (SecurityException ex) {
            Invoker.logSevere(ex);
        }
        catch (ClassNotFoundException ex) {
            Invoker.logSevere(ex);
        }
        catch (InstantiationException ex) {
            Invoker.logSevere(ex);
        }
        catch (IllegalAccessException ex) {
            Invoker.logSevere(ex);
        }
        catch (IllegalArgumentException ex) {
            Invoker.logSevere(ex);
        }
        catch (InvocationTargetException ex) {
            RuntimeException rex = new RuntimeException();
            rex.initCause(ex);
            throw ex;
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
            System.setProperty("java.class.path", origJcp);
        }
    }

    private static void logSevere(Exception ex) {
        Logger.getLogger(Invoker.class.getName()).log(Level.SEVERE, null, ex);
    }

    private static URL[] toUrls(String c) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String s : c.split(File.pathSeparator)) {
            try {
                urls.add(new File(s).toURI().toURL());
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(Invoker.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return urls.toArray(new URL[0]);
    }
}

