/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxws;

import com.sun.tools.ws.wscompile.WsgenTool;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.jaxws.AbstractJaxwsMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsGenMojo
extends AbstractJaxwsMojo {
    private boolean genWsdl;
    private File resourceDestDir;
    private String sei;
    private String protocol;
    private File sourceDestDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        String orginalSystemClasspath = this.initClassLoader(parent);
        try {
            ArrayList<String> args = this.getWsGenArgs();
            args.add(this.sei);
            WsgenTool compTool = new WsgenTool((OutputStream)System.out);
            if (!compTool.run(args.toArray(new String[args.size()]))) {
                throw new MojoExecutionException("Error executing: wsimport " + args);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(parent);
            System.setProperty("java.class.path", orginalSystemClasspath);
        }
    }

    private void init() throws MojoExecutionException, MojoFailureException {
        if (!this.destDir.exists()) {
            this.destDir.mkdirs();
        }
    }

    private ArrayList<String> getWsGenArgs() throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        if (this.verbose) {
            args.add("-verbose");
        }
        if (this.keep) {
            args.add("-keep");
        }
        if (this.sourceDestDir != null) {
            args.add("-s");
            args.add(this.sourceDestDir.getAbsolutePath());
            this.sourceDestDir.mkdirs();
        }
        args.add("-d");
        args.add(this.destDir.getAbsolutePath());
        this.destDir.mkdirs();
        if (this.genWsdl) {
            if (this.protocol != null) {
                args.add("-wsdl:" + this.protocol);
            } else {
                args.add("-wsdl");
            }
            args.add("-r");
            args.add(this.resourceDestDir.getAbsolutePath());
            this.resourceDestDir.mkdirs();
        }
        args.add(this.sei);
        this.getLog().info((CharSequence)("jaxws:wsgen args: " + args));
        return args;
    }
}

