/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.plexus.util.DirectoryScanner;

class GrammarDirectoryScanner {
    private final DirectoryScanner scanner = new DirectoryScanner();
    private File outputDirectory;
    private String parserPackage;
    private int staleMillis;
    private final List<GrammarInfo> includedGrammars;

    public GrammarDirectoryScanner() {
        this.scanner.setFollowSymlinks(true);
        this.includedGrammars = new ArrayList<GrammarInfo>();
    }

    public void setSourceDirectory(File directory) {
        if (!directory.isAbsolute()) {
            throw new IllegalArgumentException("source directory is not absolute: " + directory);
        }
        this.scanner.setBasedir(directory);
    }

    public void setParserPackage(String packageName) {
        this.parserPackage = packageName;
    }

    public void setIncludes(String[] includes) {
        this.scanner.setIncludes(includes);
    }

    public void setExcludes(String[] excludes) {
        this.scanner.setExcludes(excludes);
        this.scanner.addDefaultExcludes();
    }

    public void setOutputDirectory(File directory) {
        if (directory != null && !directory.isAbsolute()) {
            throw new IllegalArgumentException("output directory is not absolute: " + directory);
        }
        this.outputDirectory = directory;
    }

    public void setStaleMillis(int milliseconds) {
        this.staleMillis = milliseconds;
    }

    public void scan() throws IOException {
        String[] includedFiles;
        this.includedGrammars.clear();
        this.scanner.scan();
        block0: for (String includedFile : includedFiles = this.scanner.getIncludedFiles()) {
            GrammarInfo grammarInfo = new GrammarInfo(this.scanner.getBasedir(), includedFile, this.parserPackage);
            if (this.outputDirectory != null) {
                File[] targetFiles;
                File sourceFile = grammarInfo.getGrammarFile();
                for (File targetFile : targetFiles = this.getTargetFiles(this.outputDirectory, includedFile, grammarInfo)) {
                    if (targetFile.exists() && targetFile.lastModified() + (long)this.staleMillis >= sourceFile.lastModified()) continue;
                    this.includedGrammars.add(grammarInfo);
                    continue block0;
                }
                continue;
            }
            this.includedGrammars.add(grammarInfo);
        }
    }

    protected File[] getTargetFiles(File targetDirectory, String grammarFile, GrammarInfo grammarInfo) {
        File parserFile = new File(targetDirectory, grammarInfo.getParserFile());
        return new File[]{parserFile};
    }

    public GrammarInfo[] getIncludedGrammars() {
        return this.includedGrammars.toArray(new GrammarInfo[0]);
    }
}

