/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.javacc.GrammarDirectoryScanner;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JJDoc;

@Mojo(name="jjdoc")
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class JJDocMojo
extends AbstractMavenReport {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private Renderer siteRenderer;
    @Parameter
    private File[] sourceDirectories;
    @Parameter(defaultValue="${basedir}/src/main/javacc")
    private File defaultGrammarDirectoryJavaCC;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/jjtree")
    private File defaultGrammarDirectoryJJTree;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/jtb")
    private File defaultGrammarDirectoryJTB;
    @Parameter(defaultValue="jjdoc")
    private String jjdocDirectory;
    @Parameter(defaultValue="${project.reporting.outputDirectory}", property="javacc.outputDirectory")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.sourceEncoding}", property="javacc.grammarEncoding")
    private String grammarEncoding;
    @Parameter(property="javacc.cssHref")
    private String cssHref;
    @Parameter(property="javacc.text", defaultValue="false")
    private boolean text;
    @Parameter(property="javacc.bnf", defaultValue="false")
    private Boolean bnf;
    @Parameter(property="javacc.oneTable", defaultValue="true")
    private boolean oneTable;

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    private File getJJDocOutputDirectory() {
        return new File(this.getReportOutputDirectory(), this.jjdocDirectory);
    }

    private File[] getSourceDirectories() {
        LinkedHashSet<File> directories = new LinkedHashSet<File>();
        if (this.sourceDirectories != null && this.sourceDirectories.length > 0) {
            directories.addAll(Arrays.asList(this.sourceDirectories));
        } else {
            if (this.defaultGrammarDirectoryJavaCC != null) {
                directories.add(this.defaultGrammarDirectoryJavaCC);
            }
            if (this.defaultGrammarDirectoryJJTree != null) {
                directories.add(this.defaultGrammarDirectoryJJTree);
            }
            if (this.defaultGrammarDirectoryJTB != null) {
                directories.add(this.defaultGrammarDirectoryJTB);
            }
        }
        return directories.toArray(new File[directories.size()]);
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.jjdoc.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.jjdoc.short.description");
    }

    public String getOutputName() {
        return this.jjdocDirectory + "/index";
    }

    public boolean canGenerateReport() {
        File[] sourceDirs = this.getSourceDirectories();
        for (int i = 0; i < sourceDirs.length; ++i) {
            File sourceDir = sourceDirs[i];
            String[] files = sourceDir.list();
            if (files == null || files.length <= 0) continue;
            return true;
        }
        return false;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        this.generate(this.getSink(), locale);
    }

    private String getOutputFileExtension() {
        if (Boolean.TRUE.equals(this.text) || Boolean.TRUE.equals(this.bnf)) {
            return ".txt";
        }
        return ".html";
    }

    private void createReportHeader(ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.jjdoc.title"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.jjdoc.title"));
        sink.sectionTitle1_();
        sink.text(bundle.getString("report.jjdoc.description"));
        sink.section1_();
        sink.lineBreak();
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.jjdoc.table.heading"));
        sink.tableHeaderCell_();
        sink.tableRow_();
    }

    private void createReportLink(Sink sink, File sourceDirectory, File grammarFile, String linkPath) {
        sink.tableRow();
        sink.tableCell();
        if (linkPath.startsWith("/")) {
            linkPath = linkPath.substring(1);
        }
        sink.link(linkPath);
        String grammarFileRelativePath = sourceDirectory.toURI().relativize(grammarFile.toURI()).toString();
        if (grammarFileRelativePath.startsWith("/")) {
            grammarFileRelativePath = grammarFileRelativePath.substring(1);
        }
        sink.text(grammarFileRelativePath);
        sink.link_();
        sink.tableCell_();
        sink.tableRow_();
    }

    private void createReportFooter(Sink sink) {
        sink.table_();
        sink.body_();
    }

    private JJDoc newJJDoc() {
        JJDoc jjdoc = new JJDoc();
        jjdoc.setLog(this.getLog());
        jjdoc.setGrammarEncoding(this.grammarEncoding);
        jjdoc.setCssHref(this.cssHref);
        jjdoc.setText(this.text);
        jjdoc.setBnf(this.bnf);
        jjdoc.setOneTable(this.oneTable);
        return jjdoc;
    }

    private GrammarInfo[] scanForGrammars(File sourceDirectory) throws MavenReportException {
        GrammarInfo[] grammarInfos;
        if (!sourceDirectory.isDirectory()) {
            return null;
        }
        this.getLog().debug((CharSequence)("Scanning for grammars: " + sourceDirectory));
        try {
            String[] includes = new String[]{"**/*.jj", "**/*.JJ", "**/*.jjt", "**/*.JJT", "**/*.jtb", "**/*.JTB"};
            GrammarDirectoryScanner scanner = new GrammarDirectoryScanner();
            scanner.setSourceDirectory(sourceDirectory);
            scanner.setIncludes(includes);
            scanner.scan();
            grammarInfos = scanner.getIncludedGrammars();
        }
        catch (Exception e) {
            throw new MavenReportException("Failed to scan for grammars: " + sourceDirectory, e);
        }
        this.getLog().debug((CharSequence)("Found grammars: " + Arrays.asList(grammarInfos)));
        return grammarInfos;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("jjdoc-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.createReportHeader(this.getBundle(locale), sink);
        File[] sourceDirs = this.getSourceDirectories();
        for (int j = 0; j < sourceDirs.length; ++j) {
            File sourceDir = sourceDirs[j];
            GrammarInfo[] grammarInfos = this.scanForGrammars(sourceDir);
            if (grammarInfos == null) {
                this.getLog().debug((CharSequence)("Skipping non-existing source directory: " + sourceDir));
                continue;
            }
            Arrays.sort(grammarInfos, GrammarInfoComparator.getInstance());
            for (int i = 0; i < grammarInfos.length; ++i) {
                GrammarInfo grammarInfo = grammarInfos[i];
                File grammarFile = grammarInfo.getGrammarFile();
                String relativeOutputFileName = grammarInfo.getRelativeGrammarFile();
                relativeOutputFileName = relativeOutputFileName.replaceAll("(?i)\\.(jj|jjt|jtb)$", this.getOutputFileExtension());
                File jjdocOutputFile = new File(this.getJJDocOutputDirectory(), relativeOutputFileName);
                JJDoc jjdoc = this.newJJDoc();
                jjdoc.setInputFile(grammarFile);
                jjdoc.setOutputFile(jjdocOutputFile);
                try {
                    jjdoc.run();
                }
                catch (Exception e) {
                    throw new MavenReportException("Failed to create BNF documentation: " + grammarFile, e);
                }
                this.createReportLink(sink, sourceDir, grammarFile, relativeOutputFileName);
            }
        }
        this.createReportFooter(sink);
        sink.flush();
        sink.close();
    }

    private static class GrammarInfoComparator
    implements Comparator {
        private static final GrammarInfoComparator INSTANCE = new GrammarInfoComparator();

        private GrammarInfoComparator() {
        }

        public static GrammarInfoComparator getInstance() {
            return INSTANCE;
        }

        public int compare(Object o1, Object o2) {
            int rel;
            GrammarInfo info1 = (GrammarInfo)o1;
            String[] paths1 = info1.getRelativeGrammarFile().split("\\" + File.separatorChar);
            GrammarInfo info2 = (GrammarInfo)o2;
            String[] paths2 = info2.getRelativeGrammarFile().split("\\" + File.separatorChar);
            int dirs = Math.min(paths1.length, paths2.length) - 1;
            for (int i = 0; i < dirs; ++i) {
                rel = paths1[i].compareToIgnoreCase(paths2[i]);
                if (rel == 0) continue;
                return rel;
            }
            rel = paths1.length - paths2.length;
            if (rel != 0) {
                return rel;
            }
            return paths1[paths1.length - 1].compareToIgnoreCase(paths2[paths1.length - 1]);
        }
    }
}

