/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.javacc.JavaCCUtil;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.javacc.parser.Main;

public class JavaCCMojo
extends AbstractMojo {
    private Integer lookAhead;
    private Integer choiceAmbiguityCheck;
    private Integer otherAmbiguityCheck;
    private Boolean isStatic;
    private Boolean debugParser;
    private Boolean debugLookAhead;
    private Boolean debugTokenManager;
    private Boolean optimizeTokenManager;
    private Boolean errorReporting;
    private Boolean javaUnicodeEscape;
    private Boolean unicodeInput;
    private Boolean ignoreCase;
    private Boolean commonTokenAction;
    private Boolean userTokenManager;
    private Boolean userCharStream;
    private Boolean buildParser;
    private Boolean buildTokenManager;
    private Boolean sanityCheck;
    private Boolean forceLaCheck;
    private Boolean cacheTokens;
    private Boolean keepLineColumn;
    private String packageName;
    private String sourceDirectory;
    private String outputDirectory;
    private String timestampDirectory;
    private int staleMillis;
    private Set includes;
    private Set excludes;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        Set staleGrammars;
        File timestampDir;
        File outputDir;
        File sourceDir;
        if (this.packageName != null) {
            this.packageName = StringUtils.replace((String)this.packageName, (char)'.', (char)File.separatorChar);
        }
        if (!(sourceDir = this.getAbsolutePath(new File(this.sourceDirectory))).isDirectory()) {
            this.getLog().warn((CharSequence)("Source directory '" + sourceDir + "' does not exist. Skipping..."));
            return;
        }
        File outputDirPackages = outputDir = this.getAbsolutePath(new File(this.outputDirectory));
        if (this.packageName != null) {
            outputDirPackages = new File(outputDir, this.packageName);
        }
        if (!outputDirPackages.exists()) {
            outputDirPackages.mkdirs();
        }
        if (!(timestampDir = this.getAbsolutePath(new File(this.timestampDirectory))).exists()) {
            timestampDir.mkdirs();
        }
        if (this.includes == null) {
            this.includes = Collections.singleton("**/*");
        }
        if (this.excludes == null) {
            this.excludes = Collections.EMPTY_SET;
        }
        if ((staleGrammars = this.computeStaleGrammars(sourceDir, timestampDir)).isEmpty()) {
            this.getLog().info((CharSequence)("Nothing to process - all grammars in " + sourceDir + " are up to date."));
        } else {
            try {
                FileUtils.copyDirectory((File)sourceDir, (File)outputDirPackages, (String)"*.java", (String)"*.jj,*.JJ");
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to copy overriden java files.", (Exception)e);
            }
            Iterator i = staleGrammars.iterator();
            while (i.hasNext()) {
                File javaccFile = (File)i.next();
                try {
                    Main.mainProgram((String[])this.generateJavaCCArgumentList(javaccFile, outputDir));
                    File timestampFile = new File(timestampDir.toURI().resolve(sourceDir.toURI().relativize(javaccFile.toURI())));
                    FileUtils.copyFile((File)javaccFile, (File)timestampFile);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("JavaCC execution failed", e);
                }
            }
        }
        if (this.project != null) {
            this.project.addCompileSourceRoot(outputDir.getPath());
        }
    }

    private String[] generateJavaCCArgumentList(File javaccInput, File outputDir) throws MojoExecutionException {
        String outputPackage;
        ArrayList<String> argsList = new ArrayList<String>();
        if (this.lookAhead != null) {
            argsList.add("-LOOKAHEAD=" + this.lookAhead);
        }
        if (this.choiceAmbiguityCheck != null) {
            argsList.add("-CHOICE_AMBIGUITY_CHECK=" + this.choiceAmbiguityCheck);
        }
        if (this.otherAmbiguityCheck != null) {
            argsList.add("-OTHER_AMBIGUITY_CHECK=" + this.otherAmbiguityCheck);
        }
        if (this.isStatic != null) {
            argsList.add("-STATIC=" + this.isStatic);
        }
        if (this.debugParser != null) {
            argsList.add("-DEBUG_PARSER=" + this.debugParser);
        }
        if (this.debugLookAhead != null) {
            argsList.add("-DEBUG_LOOKAHEAD=" + this.debugLookAhead);
        }
        if (this.debugTokenManager != null) {
            argsList.add("-DEBUG_TOKEN_MANAGER=" + this.debugTokenManager);
        }
        if (this.optimizeTokenManager != null) {
            argsList.add("-OPTIMIZE_TOKEN_MANAGER=" + this.optimizeTokenManager);
        }
        if (this.errorReporting != null) {
            argsList.add("-ERROR_REPORTING=" + this.errorReporting);
        }
        if (this.javaUnicodeEscape != null) {
            argsList.add("-JAVA_UNICODE_ESCAPE=" + this.javaUnicodeEscape);
        }
        if (this.unicodeInput != null) {
            argsList.add("-UNICODE_INPUT=" + this.unicodeInput);
        }
        if (this.ignoreCase != null) {
            argsList.add("-IGNORE_CASE=" + this.ignoreCase);
        }
        if (this.commonTokenAction != null) {
            argsList.add("-COMMON_TOKEN_ACTION=" + this.commonTokenAction);
        }
        if (this.userTokenManager != null) {
            argsList.add("-USER_TOKEN_MANAGER=" + this.userTokenManager);
        }
        if (this.userCharStream != null) {
            argsList.add("-USER_CHAR_STREAM=" + this.userCharStream);
        }
        if (this.buildParser != null) {
            argsList.add("-BUILD_PARSER=" + this.buildParser);
        }
        if (this.buildTokenManager != null) {
            argsList.add("-BUILD_TOKEN_MANAGER=" + this.buildTokenManager);
        }
        if (this.sanityCheck != null) {
            argsList.add("-SANITY_CHECK=" + this.sanityCheck);
        }
        if (this.forceLaCheck != null) {
            argsList.add("-FORCE_LA_CHECK=" + this.forceLaCheck);
        }
        if (this.cacheTokens != null) {
            argsList.add("-CACHE_TOKENS=" + this.cacheTokens);
        }
        if (this.keepLineColumn != null) {
            argsList.add("-KEEP_LINE_COLUMN=" + this.keepLineColumn);
        }
        if ((outputPackage = this.packageName) == null) {
            outputPackage = JavaCCUtil.getDeclaredPackage(javaccInput);
        }
        this.getLog().debug((CharSequence)("Output Package: " + outputPackage));
        File outputDirPackages = outputDir;
        if (outputPackage != null) {
            outputDirPackages = new File(outputDir, outputPackage);
        }
        argsList.add("-OUTPUT_DIRECTORY:" + outputDirPackages);
        argsList.add(javaccInput.getPath());
        this.getLog().debug((CharSequence)("argslist: " + argsList.toString()));
        return argsList.toArray(new String[argsList.size()]);
    }

    private Set computeStaleGrammars(File sourceDir, File timestampDir) throws MojoExecutionException {
        SuffixMapping mapping = new SuffixMapping(".jj", ".jj");
        SuffixMapping mappingCAP = new SuffixMapping(".JJ", ".JJ");
        StaleSourceScanner scanner = new StaleSourceScanner((long)this.staleMillis, this.includes, this.excludes);
        scanner.addSourceMapping((SourceMapping)mapping);
        scanner.addSourceMapping((SourceMapping)mappingCAP);
        HashSet staleSources = new HashSet();
        try {
            staleSources.addAll(scanner.getIncludedSources(sourceDir, timestampDir));
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning source root: '" + sourceDir + "' for stale grammars to reprocess.", (Exception)((Object)e));
        }
        return staleSources;
    }

    protected File getAbsolutePath(File path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new File(this.project.getBasedir().getAbsolutePath(), path.getPath());
    }
}

