/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jalopy;

import de.hunsicker.jalopy.Jalopy;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.History;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.jalopy.Locator;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public class JalopyMojo
extends AbstractMojo {
    private String fileFormat;
    private String history;
    private boolean failOnError;
    private File sourceDirectory;
    private File testSourceDirectory;
    private String convention;
    private String srcIncludesPattern;
    private String srcExcludesPattern;
    private String testIncludesPattern;
    private String testExcludesPattern;
    private MavenProject project;
    private Locator locator;

    public void execute() throws MojoExecutionException {
        try {
            String[] filesToFormat;
            this.locator = new Locator(this.getLog(), new File(this.project.getBuild().getDirectory()));
            if (this.getSourceDirectory().exists()) {
                filesToFormat = this.getIncludedFiles(this.getSourceDirectory(), this.getSrcIncludesPattern(), this.getSrcExcludesPattern());
                this.formatFiles(this.getSourceDirectory(), filesToFormat);
            }
            if (this.getTestSourceDirectory().exists()) {
                filesToFormat = this.getIncludedFiles(this.getTestSourceDirectory(), this.getTestIncludesPattern(), this.getTestExcludesPattern());
                this.formatFiles(this.getTestSourceDirectory(), filesToFormat);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[] getIncludedFiles(File directory, String includes, String excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(StringUtils.split((String)includes, (String)","));
        scanner.setExcludes(StringUtils.split((String)excludes, (String)","));
        scanner.scan();
        String[] filesToFormat = scanner.getIncludedFiles();
        return filesToFormat;
    }

    private void formatFiles(File directory, String[] filesToFormat) throws FileNotFoundException, MojoExecutionException {
        Jalopy jalopy = new Jalopy();
        jalopy = this.createJalopy(jalopy);
        for (int i = 0; i < filesToFormat.length; ++i) {
            File currentFile = new File(directory, filesToFormat[i]);
            jalopy.setInput(currentFile);
            jalopy.setOutput(currentFile);
            jalopy.format();
            this.logMessage(jalopy, currentFile);
        }
    }

    private void logMessage(Jalopy jalopy, File currentFile) throws MojoExecutionException {
        Log log = this.getLog();
        if (jalopy.getState() == Jalopy.State.OK) {
            log.info((CharSequence)(currentFile + " formatted correctly."));
        } else if (jalopy.getState() == Jalopy.State.WARN) {
            log.warn((CharSequence)(currentFile + " formatted with warnings."));
        } else if (jalopy.getState() == Jalopy.State.ERROR) {
            log.error((CharSequence)(currentFile + " could not be formatted."));
            if (this.isFailOnError()) {
                throw new MojoExecutionException(currentFile + " could not be formatted.");
            }
        } else {
            log.info((CharSequence)(currentFile + " formatted with unknown state."));
        }
    }

    private Jalopy createJalopy(Jalopy jalopy) {
        Log log = this.getLog();
        try {
            if (this.convention != null) {
                File conventionContents = this.locator.resolveLocation(this.convention, "jalopy-convention.xml");
                Jalopy.setConvention((File)conventionContents);
            } else {
                log.info((CharSequence)"Using default convention : jalopy.xml");
                InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("jalopy.xml");
                Convention.importSettings((InputStream)in, (String)".xml");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Convention settings = Convention.getInstance();
        jalopy.setFileFormat(this.getFileFormat());
        jalopy.setInspect(settings.getBoolean(ConventionKeys.INSPECTOR, false));
        if (!this.getHistory().equalsIgnoreCase("none")) {
            jalopy.setHistoryPolicy(History.Policy.valueOf((String)this.getHistory()));
        }
        History.Method historyMethod = History.Method.valueOf((String)settings.get(ConventionKeys.HISTORY_METHOD, ConventionDefaults.HISTORY_METHOD));
        jalopy.setHistoryMethod(historyMethod);
        jalopy.setBackup(settings.getInt(ConventionKeys.BACKUP_LEVEL, 0) > 0);
        jalopy.setForce(settings.getBoolean(ConventionKeys.FORCE_FORMATTING, false));
        return jalopy;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public String getSrcIncludesPattern() {
        return this.srcIncludesPattern;
    }

    public void setSrcIncludesPattern(String srcIncludesPattern) {
        this.srcIncludesPattern = srcIncludesPattern;
    }

    public String getSrcExcludesPattern() {
        return this.srcExcludesPattern;
    }

    public void setSrcExcludesPattern(String srcExcludesPattern) {
        this.srcExcludesPattern = srcExcludesPattern;
    }

    public String getHistory() {
        return this.history;
    }

    public void setHistory(String history) {
        this.history = history;
    }

    public File getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    public void setTestSourceDirectory(File testSourceDirectory) {
        this.testSourceDirectory = testSourceDirectory;
    }

    public String getTestIncludesPattern() {
        return this.testIncludesPattern;
    }

    public void setTestIncludesPattern(String testIncludesPattern) {
        this.testIncludesPattern = testIncludesPattern;
    }

    public String getTestExcludesPattern() {
        return this.testExcludesPattern;
    }

    public void setTestExcludesPattern(String testExcludesPattern) {
        this.testExcludesPattern = testExcludesPattern;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }
}

