/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.idlj;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.idlj.CompilerTranslator;
import org.codehaus.mojo.idlj.IdljTranslator;
import org.codehaus.mojo.idlj.JacorbTranslator;
import org.codehaus.mojo.idlj.Source;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIDLJMojo
extends AbstractMojo {
    private List<Source> sources;
    private boolean debug;
    private boolean failOnError;
    private MavenProject project;
    private int staleMillis;
    private MavenProjectHelper projectHelper;
    private File timestampDirectory;
    private String compiler;
    private DependenciesFacade dependencies;
    private static final DependenciesFacade DEPENDENCIES_FACADE = new DependenciesFacadeImpl();

    protected AbstractIDLJMojo() {
        this(DEPENDENCIES_FACADE);
    }

    AbstractIDLJMojo(DependenciesFacade dependencies) {
        this.dependencies = dependencies;
    }

    protected abstract File getSourceDirectory();

    protected abstract File[] getIncludeDirs();

    protected abstract File getOutputDirectory();

    public void execute() throws MojoExecutionException {
        this.prepareGeneratedSourceDirectory(this.getOutputDirectory());
        this.createIfAbsent(this.timestampDirectory);
        if (this.isSourceSpecified()) {
            this.translateSources(this.createTranslator(), this.sources);
        } else {
            this.translateInferredSource(this.createTranslator());
        }
    }

    private void prepareGeneratedSourceDirectory(File directory) throws MojoExecutionException {
        this.createIfAbsent(directory);
        this.failIfNotWriteable(directory);
        this.addCompileSourceRoot(directory);
    }

    private boolean isSourceSpecified() {
        return this.sources != null;
    }

    private void translateInferredSource(CompilerTranslator translator) throws MojoExecutionException {
        this.processSource(new Source(), translator);
    }

    private void translateSources(CompilerTranslator translator, List<Source> sourceList) throws MojoExecutionException {
        for (Source source : sourceList) {
            this.processSource(source, translator);
        }
    }

    private CompilerTranslator createTranslator() throws MojoExecutionException {
        CompilerTranslator translator = this.createAppropriateTranslatorType();
        translator.setDebug(this.debug);
        translator.setFailOnError(this.failOnError);
        translator.setLog(this.getLog());
        return translator;
    }

    private CompilerTranslator createAppropriateTranslatorType() throws MojoExecutionException {
        if (this.compiler == null) {
            return new IdljTranslator();
        }
        if (this.compiler.equals("idlj")) {
            return new IdljTranslator();
        }
        if (this.compiler.equals("jacorb")) {
            return new JacorbTranslator();
        }
        throw new MojoExecutionException("Compiler not supported: " + this.compiler);
    }

    private void failIfNotWriteable(File directory) throws MojoExecutionException {
        if (!this.dependencies.isWriteable(directory)) {
            throw new MojoExecutionException("Cannot write in : " + directory);
        }
    }

    private void createIfAbsent(File directory) {
        if (!this.dependencies.exists(directory)) {
            this.dependencies.createDirectory(directory);
        }
    }

    private void processSource(Source source, CompilerTranslator translator) throws MojoExecutionException {
        Set<File> staleGrammars = this.computeStaleGrammars(source);
        this.reportProcessingNeeded(staleGrammars);
        for (File idlFile : staleGrammars) {
            this.processIdlFile(source, translator, idlFile);
        }
    }

    private void processIdlFile(Source source, CompilerTranslator translator, File idlFile) throws MojoExecutionException {
        try {
            this.translateIdlFile(idlFile, source, translator);
            this.copyToTimestampDirectory(idlFile);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed to copy IDL file to timestamp directory: " + e));
        }
    }

    private void translateIdlFile(File idlFile, Source source, CompilerTranslator translator) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Processing: " + idlFile.toString()));
        translator.invokeCompiler(this.getSourceDirectory().getAbsolutePath(), this.getIncludeDirs(), this.getOutputDirectory().getAbsolutePath(), idlFile.toString(), source);
    }

    private void copyToTimestampDirectory(File idlFile) throws MojoExecutionException, IOException {
        URI relativeURI = this.getSourceDirectory().toURI().relativize(idlFile.toURI());
        File timestampFile = new File(this.timestampDirectory.toURI().resolve(relativeURI));
        this.dependencies.copyFile(idlFile, timestampFile);
    }

    private void reportProcessingNeeded(Set<File> staleGrammars) throws MojoExecutionException {
        if (staleGrammars.size() > 0) {
            this.getLog().info((CharSequence)("Processing " + staleGrammars.size() + " grammar files to " + this.getOutputDirectory()));
        } else {
            this.getLog().info((CharSequence)"Nothing to compile - all idl files are up to date");
        }
    }

    private Set<File> computeStaleGrammars(Source source) throws MojoExecutionException {
        File sourceDir = this.getSourceDirectory();
        this.getLog().debug((CharSequence)("sourceDir : " + sourceDir));
        return this.getStaleSources(this.createIdlScanner(source), sourceDir);
    }

    private Set<File> getStaleSources(SourceInclusionScanner scanner, File sourceDir) throws MojoExecutionException {
        try {
            return this.tryToGetStaleSources(scanner, sourceDir);
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning source root: '" + sourceDir + "' for stale CORBA IDL files to reprocess.", (Exception)((Object)e));
        }
    }

    private Set<File> tryToGetStaleSources(SourceInclusionScanner scanner, File sourceDir) throws InclusionScanException {
        if (this.isExistingDirectory(sourceDir)) {
            return scanner.getIncludedSources(sourceDir, this.timestampDirectory);
        }
        this.getLog().debug((CharSequence)"sourceDir isn't a directory");
        return new HashSet<File>();
    }

    private boolean isExistingDirectory(File sourceDir) {
        return this.dependencies.exists(sourceDir) && this.dependencies.isDirectory(sourceDir);
    }

    private SourceInclusionScanner createIdlScanner(Source source) {
        Set<String> includes = this.getNonNullSet("includes", source.getIncludes(), "**/*.idl");
        Set<String> excludes = this.getNonNullSet("excludes", source.getExcludes(), new String[0]);
        SourceInclusionScanner scanner = this.dependencies.createSourceInclusionScanner(this.staleMillis, includes, excludes);
        scanner.addSourceMapping((SourceMapping)new SuffixMapping(".idl", ".idl"));
        return scanner;
    }

    private Set<String> getNonNullSet(String comment, Set<String> set, String ... defaultValues) {
        this.getLog().debug((CharSequence)(comment + ": " + set));
        if (set == null) {
            set = new HashSet<String>();
            Collections.addAll(set, defaultValues);
        }
        return set;
    }

    protected abstract void addCompileSourceRoot(File var1);

    protected MavenProject getProject() {
        return this.project;
    }

    protected MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DependenciesFacadeImpl
    implements DependenciesFacade {
        DependenciesFacadeImpl() {
        }

        @Override
        public void copyFile(File sourceFile, File targetFile) throws IOException {
            FileUtils.copyFile((File)sourceFile, (File)targetFile);
        }

        @Override
        public SourceInclusionScanner createSourceInclusionScanner(int updatedWithinMsecs, Set<String> includes, Set<String> excludes) {
            return new StaleSourceScanner((long)updatedWithinMsecs, includes, excludes);
        }

        @Override
        public boolean exists(File file) {
            return file.exists();
        }

        @Override
        public void createDirectory(File directory) {
            directory.mkdirs();
        }

        @Override
        public boolean isWriteable(File directory) {
            return directory.canWrite();
        }

        @Override
        public boolean isDirectory(File file) {
            return file.isDirectory();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface DependenciesFacade {
        public SourceInclusionScanner createSourceInclusionScanner(int var1, Set<String> var2, Set<String> var3);

        public void copyFile(File var1, File var2) throws IOException;

        public boolean exists(File var1);

        public void createDirectory(File var1);

        public boolean isWriteable(File var1);

        public boolean isDirectory(File var1);
    }
}

