/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.hibernate3.configuration;

import java.io.File;
import java.lang.reflect.Constructor;
import org.codehaus.mojo.hibernate3.HibernateUtils;
import org.codehaus.mojo.hibernate3.configuration.AbstractComponentConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.util.ReflectHelper;

public class JDBCComponentConfiguration
extends AbstractComponentConfiguration {
    public String getName() {
        return "jdbcconfiguration";
    }

    protected Configuration createConfiguration() {
        return new JDBCMetaDataConfiguration();
    }

    protected void doConfiguration(Configuration configuration) {
        String detectOptimisticLock;
        String detectManyToMany;
        JDBCMetaDataConfiguration jmdc = (JDBCMetaDataConfiguration)configuration;
        super.doConfiguration((Configuration)jmdc);
        jmdc.setPreferBasicCompositeIds(this.getExporterMojo().getComponentProperty("preferbasiccompositeids", true));
        DefaultReverseEngineeringStrategy strategy = new DefaultReverseEngineeringStrategy();
        strategy = this.loadRevengFile((ReverseEngineeringStrategy)strategy);
        strategy = this.loadReverseStrategy((ReverseEngineeringStrategy)strategy);
        ReverseEngineeringSettings qqsettings = new ReverseEngineeringSettings((ReverseEngineeringStrategy)strategy);
        String packageName = this.getExporterMojo().getComponentProperty("packagename");
        if (packageName != null) {
            qqsettings.setDefaultPackageName(packageName);
        }
        if ("false".equals(detectManyToMany = this.getExporterMojo().getComponentProperty("detectmanytomany"))) {
            qqsettings.setDetectManyToMany(false);
        }
        if ("false".equals(detectOptimisticLock = this.getExporterMojo().getComponentProperty("detectoptmisticlock"))) {
            qqsettings.setDetectOptimisticLock(false);
        }
        strategy.setSettings(qqsettings);
        jmdc.setReverseEngineeringStrategy((ReverseEngineeringStrategy)strategy);
        jmdc.readFromJDBC();
    }

    private ReverseEngineeringStrategy loadRevengFile(ReverseEngineeringStrategy delegate) {
        String revengFile = this.getExporterMojo().getComponentProperty("revengfile");
        if (revengFile != null) {
            OverrideRepository or = new OverrideRepository();
            File rf = HibernateUtils.getFile((File)this.getExporterMojo().getProject().getBasedir(), (String)revengFile);
            if (rf == null) {
                this.getExporterMojo().getLog().info((CharSequence)"Couldn't find the revengfile in the project. Trying absolute path.");
                rf = HibernateUtils.getFile(null, (String)revengFile);
            }
            if (rf != null) {
                or.addFile(rf);
                return or.getReverseEngineeringStrategy(delegate);
            }
        }
        return delegate;
    }

    private ReverseEngineeringStrategy loadReverseStrategy(ReverseEngineeringStrategy delegate) {
        String reverseStrategy = this.getExporterMojo().getComponentProperty("reversestrategy");
        if (reverseStrategy != null) {
            try {
                Class clazz = ReflectHelper.classForName((String)reverseStrategy);
                Constructor constructor = clazz.getConstructor(ReverseEngineeringStrategy.class);
                return (ReverseEngineeringStrategy)constructor.newInstance(delegate);
            }
            catch (NoSuchMethodException e) {
                try {
                    this.getExporterMojo().getLog().info((CharSequence)("Could not find public " + reverseStrategy + "(ReverseEngineeringStrategy delegate) constructor on ReverseEngineeringStrategy. Trying no-arg version."));
                    Class clazz = ReflectHelper.classForName((String)reverseStrategy);
                    ReverseEngineeringStrategy rev = (ReverseEngineeringStrategy)clazz.newInstance();
                    this.getExporterMojo().getLog().info((CharSequence)"Using non-delegating strategy, thus packagename and revengfile will be ignored.");
                    return rev;
                }
                catch (Exception eq) {
                    this.getExporterMojo().getLog().error((CharSequence)("Could not create or find " + reverseStrategy + " with default no-arg constructor"), (Throwable)eq);
                }
            }
            catch (Exception e) {
                this.getExporterMojo().getLog().error((CharSequence)("Could not create or find " + reverseStrategy + " with one argument delegate constructor"), (Throwable)e);
            }
        }
        return delegate;
    }
}

