/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt.test;

import java.io.File;
import java.util.ArrayList;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.maven.surefire.report.BriefConsoleReporter;
import org.apache.maven.surefire.report.FileReporter;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.report.XMLReporter;

public class MavenTestRunner
extends TestRunner {
    private ReporterManager reportManager;
    private boolean testHadFailed;

    public static void main(String[] args) {
        try {
            MavenTestRunner runner = new MavenTestRunner();
            TestResult r = runner.start(args);
            if (!r.wasSuccessful()) {
                System.exit(1);
            }
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println(t.getMessage());
            System.exit(2);
        }
    }

    protected TestResult createTestResult() {
        TestResult result = super.createTestResult();
        result.addListener((TestListener)this);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult doRun(Test suite, boolean wait) {
        try {
            this.reportManager.runStarting(suite.countTestCases());
            ReportEntry report = new ReportEntry(((Object)((Object)this)).getClass().getName(), suite.toString(), "starting");
            this.reportManager.testSetStarting(report);
            TestResult result = this.createTestResult();
            suite.run(result);
            TestResult testResult = result;
            return testResult;
        }
        catch (ReporterException e) {
            System.err.println("Failed to log in test report " + (Object)((Object)e));
            TestResult testResult = null;
            return testResult;
        }
        finally {
            ReportEntry report = new ReportEntry(((Object)((Object)this)).getClass().getName(), suite.toString(), "ended");
            this.reportManager.testSetCompleted(report);
            this.reportManager.runCompleted();
        }
    }

    public MavenTestRunner() {
        String dir = System.getProperty("surefire.reports");
        ArrayList<Object> reports = new ArrayList<Object>();
        reports.add(new XMLReporter(new File(dir), Boolean.valueOf(false)));
        reports.add(new FileReporter(new File(dir), Boolean.valueOf(false)));
        reports.add(new BriefConsoleReporter(Boolean.valueOf(true)));
        this.reportManager = new ReporterManager(reports);
    }

    public void startTest(Test test) {
        this.testHadFailed = false;
        ReportEntry report = new ReportEntry(test.getClass().getName(), test.toString(), test.getClass().getName());
        this.reportManager.testStarting(report);
    }

    public void endTest(Test test) {
        if (!this.testHadFailed) {
            ReportEntry report = new ReportEntry(test.getClass().getName(), test.toString(), test.getClass().getName());
            this.reportManager.testSucceeded(report);
        }
    }

    public void addError(Test test, Throwable t) {
        String desc = test.toString();
        ReportEntry report = new ReportEntry(test.getClass().getName(), desc, desc, this.getStackTraceWriter(test, t));
        this.reportManager.testError(report);
        this.testHadFailed = true;
    }

    public void addFailure(Test test, AssertionFailedError t) {
        String desc = test.toString();
        ReportEntry report = new ReportEntry(test.getClass().getName(), desc, desc, this.getStackTraceWriter(test, (Throwable)t));
        this.reportManager.testFailed(report);
        this.testHadFailed = true;
    }

    private StackTraceWriter getStackTraceWriter(Test test, Throwable t) {
        String name = test.getClass().getName();
        String testName = "UNKNOWN";
        if (test instanceof TestSuite) {
            testName = ((TestSuite)test).getName();
        }
        return new PojoStackTraceWriter(name, testName, t);
    }
}

