/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt.shell;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.gwt.GwtRuntime;
import org.codehaus.mojo.gwt.GwtVersion;
import org.codehaus.mojo.gwt.shell.AbstractGwtShellMojo;
import org.codehaus.mojo.gwt.shell.AbstractGwtWebMojo;
import org.codehaus.mojo.gwt.shell.MakeCatalinaBase;
import org.codehaus.plexus.util.FileUtils;

public class RunMojo
extends AbstractGwtWebMojo {
    private File hostedWebapp;
    private MavenProject executedProject;
    private String runTarget;
    private int runTimeOut;
    private int port;
    private File tomcat;
    private File buildOutputDirectory;
    private File contextXml;
    private boolean noServer;
    private String server;
    private String shellServletMappingURL;
    private String whitelist;
    private String blacklist;
    private Map<String, String> systemProperties;

    public String getRunTarget() {
        return this.runTarget;
    }

    public String getRunModule() throws MojoExecutionException {
        String[] modules = this.getModules();
        if (this.noServer) {
            if (modules.length != 1) {
                this.getLog().error((CharSequence)"Running in 'noserver' mode you must specify the single module to run using -Dgwt.module=...");
                throw new MojoExecutionException("No single module specified");
            }
            return modules[0];
        }
        if (modules.length == 1) {
            return modules[0];
        }
        int dash = this.runTarget.indexOf(47);
        if (dash > 0) {
            return this.runTarget.substring(0, dash);
        }
        throw new MojoExecutionException("Unable to choose a GWT module to run. Please specify your module(s) in the configuration");
    }

    public String getStartupUrl() throws MojoExecutionException {
        if (this.noServer) {
            return this.runTarget;
        }
        int dash = this.runTarget.indexOf(47);
        if (dash > 0) {
            String[] modules;
            String prefix = this.runTarget.substring(0, dash);
            for (String module : modules = this.getModules()) {
                if (!prefix.equals(module)) continue;
                return this.readModule(module).getPath() + '/' + this.runTarget.substring(dash + 1);
            }
        }
        return this.runTarget;
    }

    protected String getFileName() {
        return "run";
    }

    public void doExecute(GwtRuntime runtime) throws MojoExecutionException, MojoFailureException {
        String clazz = runtime.getVersion().getShellFQCN();
        AbstractGwtShellMojo.JavaCommand cmd = new AbstractGwtShellMojo.JavaCommand(clazz, runtime).withinScope("runtime").arg(runtime.getVersion().getWebOutputArgument()).arg(this.hostedWebapp.getAbsolutePath()).arg("-gen").arg(this.getGen().getAbsolutePath()).arg("-logLevel").arg(this.getLogLevel());
        if (runtime.getVersion().compareTo(GwtVersion.TWO_DOT_ZERO) < 0) {
            cmd.arg("-style").arg(this.getStyle());
        }
        cmd.arg("-port").arg(Integer.toString(this.getPort())).arg(this.noServer, "-noserver");
        if (this.server != null) {
            cmd.arg("-server").arg(this.server);
        }
        if (this.whitelist != null && this.whitelist.length() > 0) {
            cmd.arg("-whitelist").arg(this.whitelist);
        }
        if (this.blacklist != null && this.blacklist.length() > 0) {
            cmd.arg("-blacklist").arg(this.blacklist);
        }
        if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
            for (String key : this.systemProperties.keySet()) {
                String value = this.systemProperties.get(key);
                if (value != null) {
                    this.getLog().info((CharSequence)(" " + key + "=" + value));
                    cmd.systemProperty(key, value);
                    continue;
                }
                this.getLog().info((CharSequence)("skip sysProps " + key + " with empty value"));
            }
        }
        switch (runtime.getVersion().getEmbeddedServer()) {
            case TOMCAT: {
                try {
                    this.makeCatalinaBase();
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Unable to build catalina.base", e);
                }
                cmd.systemProperty("catalina.base", this.getTomcat().getAbsolutePath()).arg(this.getRunTarget());
                break;
            }
            default: {
                if (!this.noServer) {
                    this.setupExplodedWar();
                } else {
                    this.getLog().info((CharSequence)"noServer is set! Skipping exploding war file...");
                }
                cmd.arg("-startupUrl").arg(this.getStartupUrl());
                if (runtime.getVersion().supportMultiModuleShell()) {
                    for (String module : this.getModules()) {
                        cmd.arg(module);
                    }
                    break;
                }
                cmd.arg(this.getRunModule());
            }
        }
        cmd.execute();
    }

    private void setupExplodedWar() throws MojoExecutionException {
        this.getLog().info((CharSequence)("create exploded Jetty webapp in " + this.hostedWebapp));
        File classes = new File(this.hostedWebapp, "WEB-INF/classes");
        classes.mkdirs();
        if (!this.buildOutputDirectory.getAbsolutePath().equals(classes.getAbsolutePath())) {
            this.getLog().warn((CharSequence)"Your POM <build><outputdirectory> does not match your hosted webapp WEB-INF/classes folder for GWT Hosted browser to see your classes.");
            try {
                FileUtils.copyDirectoryStructure((File)this.buildOutputDirectory, (File)classes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy classes to " + classes, (Exception)e);
            }
        }
        File lib = new File(this.hostedWebapp, "WEB-INF/lib");
        lib.mkdirs();
        Set<Artifact> artifacts = this.getProjectArtifacts();
        for (Artifact artifact : artifacts) {
            try {
                if (artifact.getFile().isDirectory()) continue;
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)lib);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy runtime dependency " + artifact, (Exception)e);
            }
        }
    }

    private void makeCatalinaBase() throws Exception {
        this.getLog().debug((CharSequence)"make catalina base for embedded Tomcat");
        if (this.getWebXml() != null && this.getWebXml().exists()) {
            this.getLog().info((CharSequence)("source web.xml present - " + this.getWebXml() + " - using it with embedded Tomcat"));
        } else {
            this.getLog().info((CharSequence)"source web.xml NOT present, using default empty web.xml for shell");
        }
        new MakeCatalinaBase(this.getTomcat(), this.getWebXml(), this.shellServletMappingURL).setup();
        if (this.getContextXml() != null && this.getContextXml().exists()) {
            this.getLog().info((CharSequence)("contextXml parameter present - " + this.getContextXml() + " - using it for embedded Tomcat ROOT.xml"));
            FileUtils.copyFile((File)this.getContextXml(), (File)new File(this.getTomcat(), "conf/gwt/localhost/ROOT.xml"));
        }
    }

    public File getContextXml() {
        return this.contextXml;
    }

    public int getPort() {
        return this.port;
    }

    public File getTomcat() {
        return this.tomcat;
    }

    public void setRunTimeOut(int runTimeOut) {
        this.setTimeOut(runTimeOut);
    }

    public void setExecutedProject(MavenProject executedProject) {
        this.executedProject = executedProject;
    }

    public MavenProject getProject() {
        return this.executedProject;
    }
}

