/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt.shell;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.gwt.GwtRuntime;
import org.codehaus.mojo.gwt.shell.AbstractGwtShellMojo;

public class I18NMojo
extends AbstractGwtShellMojo {
    private String[] i18nMessagesBundles;
    private String i18nMessagesBundle;
    private String[] i18nConstantsBundles;
    private String i18nConstantsBundle;
    private String[] i18nConstantsWithLookupBundles;
    private String i18nConstantsWithLookupBundle;

    public void doExecute(GwtRuntime runtime) throws MojoExecutionException, MojoFailureException {
        this.setup();
        boolean generated = false;
        if (this.i18nConstantsWithLookupBundles != null) {
            for (String target : this.i18nConstantsWithLookupBundles) {
                this.ensureTargetPackageExists(this.getGenerateDirectory(), target);
                new AbstractGwtShellMojo.JavaCommand("com.google.gwt.i18n.tools.I18NSync", runtime).withinScope("compile").arg("-out").arg(this.getGenerateDirectory().getAbsolutePath()).arg("-createConstantsWithLookup").arg(target).execute();
                generated = true;
            }
        }
        if (this.i18nConstantsBundles != null) {
            for (String target : this.i18nConstantsBundles) {
                this.ensureTargetPackageExists(this.getGenerateDirectory(), target);
                new AbstractGwtShellMojo.JavaCommand("com.google.gwt.i18n.tools.I18NSync", runtime).withinScope("compile").arg("-out").arg(this.getGenerateDirectory().getAbsolutePath()).arg(target).execute();
                generated = true;
            }
        }
        if (this.i18nMessagesBundles != null) {
            for (String target : this.i18nMessagesBundles) {
                this.ensureTargetPackageExists(this.getGenerateDirectory(), target);
                new AbstractGwtShellMojo.JavaCommand("com.google.gwt.i18n.tools.I18NSync", runtime).withinScope("compile").arg("-out").arg(this.getGenerateDirectory().getAbsolutePath()).arg("-createMessages").arg(target).execute();
                generated = true;
            }
        }
        if (generated) {
            this.getLog().debug((CharSequence)("add compile source root " + this.getGenerateDirectory()));
            this.addCompileSourceRoot(this.getGenerateDirectory());
        }
    }

    private void setup() throws MojoExecutionException {
        if (this.i18nConstantsWithLookupBundles == null && this.i18nConstantsWithLookupBundle != null) {
            this.i18nConstantsWithLookupBundles = new String[]{this.i18nConstantsWithLookupBundle};
        }
        if (this.i18nConstantsBundles == null && this.i18nConstantsBundle != null) {
            this.i18nConstantsBundles = new String[]{this.i18nConstantsBundle};
        }
        if (this.i18nMessagesBundles == null && this.i18nMessagesBundle != null) {
            this.i18nMessagesBundles = new String[]{this.i18nMessagesBundle};
        }
        if (this.i18nMessagesBundles == null && this.i18nConstantsBundles == null && this.i18nConstantsWithLookupBundles == null) {
            throw new MojoExecutionException("neither i18nConstantsBundles, i18nMessagesBundles nor i18nConstantsWithLookupBundles present. \nCannot execute i18n goal");
        }
    }

    private void ensureTargetPackageExists(File generateDirectory, String targetName) {
        targetName = targetName.substring(0, targetName.lastIndexOf(46));
        String targetPackage = targetName.replace('.', File.separatorChar);
        this.getLog().debug((CharSequence)("ensureTargetPackageExists, targetName : " + targetName + ", targetPackage : " + targetPackage));
        File targetPackageDirectory = new File(generateDirectory, targetPackage);
        if (!targetPackageDirectory.exists()) {
            targetPackageDirectory.mkdirs();
        }
    }
}

