/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt.eclipse;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.gwt.GwtRuntime;
import org.codehaus.mojo.gwt.eclipse.EclipseUtil;
import org.codehaus.mojo.gwt.shell.TestMojo;
import org.codehaus.mojo.gwt.test.TestTemplate;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class EclipseTestMojo
extends TestMojo {
    private EclipseUtil eclipseUtil;
    private String extraJvmArgs;
    private MavenProject executedProject;
    private File testOutputDirectory;

    protected void doExecute(final GwtRuntime runtime) throws MojoExecutionException, MojoFailureException {
        new TestTemplate(this.getProject(), this.includes, this.excludes, new TestTemplate.CallBack(){

            public void doWithTest(File sourceDir, String test) throws MojoExecutionException {
                EclipseTestMojo.this.createLaunchConfigurationForGwtTestCase(runtime, sourceDir, test);
            }
        });
    }

    private void createLaunchConfigurationForGwtTestCase(GwtRuntime runtime, File testSrc, String test) throws MojoExecutionException {
        File testFile = new File(testSrc, test);
        String fqcn = test.replace(File.separatorChar, '.').substring(0, test.lastIndexOf(46));
        File launchFile = new File(this.getProject().getBasedir(), fqcn + ".launch");
        if (launchFile.exists() && launchFile.lastModified() > testFile.lastModified()) {
            return;
        }
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(EclipseTestMojo.class, "");
        HashMap<String, Object> context = new HashMap<String, Object>();
        LinkedList sources = new LinkedList();
        sources.addAll(this.executedProject.getTestCompileSourceRoots());
        sources.addAll(this.executedProject.getCompileSourceRoots());
        context.put("sources", sources);
        context.put("test", fqcn);
        int basedir = this.getProject().getBasedir().getAbsolutePath().length();
        context.put("out", this.testOutputDirectory.getAbsolutePath().substring(basedir + 1));
        context.put("extraJvmArgs", this.getExtraJvmArgs());
        context.put("project", this.eclipseUtil.getProjectName(this.getProject()));
        context.put("gwtDevJarPath", runtime.getGwtDevJar().getAbsolutePath());
        try {
            XmlStreamWriter configWriter = WriterFactory.newXmlWriter((File)launchFile);
            Template template = cfg.getTemplate("test-launch.fm", "UTF-8");
            template.process(context, (Writer)configWriter);
            configWriter.flush();
            configWriter.close();
            this.getLog().info((CharSequence)("Write launch configuration for GWT test : " + launchFile.getAbsolutePath()));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to write launch configuration", (Exception)ioe);
        }
        catch (TemplateException te) {
            throw new MojoExecutionException("Unable to merge freemarker template", (Exception)((Object)te));
        }
    }
}

