/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.surefire.booter.output.ForkingStreamConsumer;
import org.apache.maven.surefire.booter.output.OutputConsumer;
import org.apache.maven.surefire.booter.output.StandardOutputConsumer;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.cli.CommandLineUtils;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.cli.Commandline;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.cli.StreamConsumer;
import org.apache.maven.surefire.report.ReporterManager;
import org.codehaus.mojo.gwt.AbstractGwtMojo;
import org.codehaus.mojo.gwt.TestTemplate;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMojo
extends AbstractGwtMojo {
    private boolean skipTests;
    private boolean skipExec;
    private boolean skip;
    private String out;
    private int timeOut;
    private String includes;
    private String excludes;
    private File reportsDirectory;
    private int failures;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipTests || this.skipExec) {
            return;
        }
        final ArrayList classpath = new ArrayList();
        classpath.addAll(this.getProject().getCompileSourceRoots());
        classpath.addAll(this.getProject().getTestCompileSourceRoots());
        try {
            classpath.addAll(this.getProject().getTestClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Failed to resolve dependencies", (Exception)((Object)e));
        }
        final String jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        this.getLog().debug((CharSequence)("Using JVM: " + jvm));
        new TestTemplate(this.getProject(), this.includes, this.excludes, new TestTemplate.CallBack(){

            public void doWithTest(File sourceDir, String test) throws MojoExecutionException {
                TestMojo.this.forkToRunTest(classpath, jvm, test);
            }
        });
        if (this.failures > 0) {
            throw new MojoExecutionException("There was test failures.");
        }
    }

    private void forkToRunTest(List<String> classpath, String jvm, String test) throws MojoExecutionException {
        classpath.add(this.getClassPathElementFor(TestMojo.class));
        classpath.add(this.getClassPathElementFor(ReporterManager.class));
        test = test.substring(0, test.length() - 5);
        test = StringUtils.replace((String)test, (String)File.separator, (String)".");
        try {
            Commandline cli = new Commandline();
            cli.setExecutable(jvm);
            cli.createArg(false).setLine("-classpath");
            cli.createArg(false).setLine(StringUtils.join(classpath.iterator(), (String)File.pathSeparator));
            cli.createArg(false).setLine(" -Xmx256M ");
            cli.createArg(false).setLine(" -Dsurefire.reports=\"" + this.reportsDirectory + "\"");
            cli.createArg(false).setLine(" -Dgwt.args=\"-out " + this.out + "\"");
            new File(this.getProject().getBasedir(), this.out).mkdirs();
            cli.createArg(false).setLine(" org.codehaus.mojo.gwt.MavenTestRunner ");
            cli.createArg(false).setLine(test);
            this.getLog().debug((CharSequence)("execute : " + cli.toString()));
            ForkingStreamConsumer systemOut = new ForkingStreamConsumer((OutputConsumer)new StandardOutputConsumer());
            ForkingStreamConsumer systemErr = new ForkingStreamConsumer((OutputConsumer)new StandardOutputConsumer());
            if (CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)systemOut, (StreamConsumer)systemErr, (int)this.timeOut) != 0) {
                ++this.failures;
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to run GWT tests", e);
        }
    }

    private String getClassPathElementFor(Class<?> clazz) {
        URL url;
        String path;
        String classFile = clazz.getName().replace('.', '/') + ".class";
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ((Object)((Object)this)).getClass().getClassLoader();
        }
        if ((path = (path = (url = cl.getResource(classFile)).toString()).startsWith("jar:") ? path.substring(4, path.indexOf("!")) : path.substring(0, path.length() - classFile.length())).startsWith("file:")) {
            path = path.substring(5);
        }
        return path;
    }
}

