/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:gwt-maven-plugin:1.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven GWT Plugin 1.0", 0);
        this.append(sb, "Maven plugin for the Google Web Toolkit.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 7 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "compile".equals(this.goal)) {
            this.append(sb, "gwt:compile", 0);
            this.append(sb, "Goal which compiles a GWT file.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "gen", 2);
                this.append(sb, "The directory into which generated files will be written for review", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2);
                this.append(sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3);
                this.append(sb, "", 0);
                this.append(sb, "logLevel (Default: WARN)", 2);
                this.append(sb, "The level of logging detail: ERROR, WARN, INFO, TRACE, DEBUG, SPAM, or ALL", 3);
                this.append(sb, "", 0);
                this.append(sb, "module", 2);
                this.append(sb, "A single GWT module (Shortcut for modules)", 3);
                this.append(sb, "", 0);
                this.append(sb, "modules", 2);
                this.append(sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2);
                this.append(sb, "Location of the file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "style (Default: OBF)", 2);
                this.append(sb, "Script output style: OBF[USCATED], PRETTY, or DETAILED", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "eclipse".equals(this.goal)) {
            this.append(sb, "gwt:eclipse", 0);
            this.append(sb, "Goal which install GWT artifacts in local repository.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "additionalPageParameters", 2);
                this.append(sb, "Additional parameters to append to the module URL. For example, gwt-log users will set 'log_level=DEBUG'", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2);
                this.append(sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3);
                this.append(sb, "", 0);
                this.append(sb, "module", 2);
                this.append(sb, "A single GWT module (Shortcut for modules)", 3);
                this.append(sb, "", 0);
                this.append(sb, "modules", 2);
                this.append(sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2);
                this.append(sb, "Location of the file.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "eclipseTest".equals(this.goal)) {
            this.append(sb, "gwt:eclipseTest", 0);
            this.append(sb, "Goal which install GWT artifacts in local repository.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "additionalPageParameters", 2);
                this.append(sb, "Additional parameters to append to the module URL. For example, gwt-log users will set 'log_level=DEBUG'", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of ant-style exclusion patterns for GWT integration tests", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2);
                this.append(sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes (Default: **/*GwtTest.java)", 2);
                this.append(sb, "Comma separated list of ant-style inclusion patterns for GWT integration tests", 3);
                this.append(sb, "", 0);
                this.append(sb, "module", 2);
                this.append(sb, "A single GWT module (Shortcut for modules)", 3);
                this.append(sb, "", 0);
                this.append(sb, "modules", 2);
                this.append(sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2);
                this.append(sb, "Location of the file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testOutputDirectory (Default: ${project.build.directory}/www-test)", 2);
                this.append(sb, "Location of the file.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "generateAsync".equals(this.goal)) {
            this.append(sb, "gwt:generateAsync", 0);
            this.append(sb, "Goal which generate Asyn interface.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: false)", 2);
                this.append(sb, "Stop the build on error", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2);
                this.append(sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcExtension", 2);
                this.append(sb, "Extension for GWT-RPC. May be set to 'rpc' if you want to map GWT-RPC calls to '*.rpc' in web.xml, for example when using Spring dispatch servlet to handle RPC requests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "servicePattern (Default: **/*Service.java)", 2);
                this.append(sb, "Pattern for GWT service interface", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "gwt:help", 0);
            this.append(sb, "Display help information on gwt-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0gwt:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "i18n".equals(this.goal)) {
            this.append(sb, "gwt:i18n", 0);
            this.append(sb, "Execute the i18nCreator tool", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "constantsWithLookup", 2);
                this.append(sb, "If true, create scripts for a ConstantsWithLookup interface rather than a Constants one", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2);
                this.append(sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3);
                this.append(sb, "", 0);
                this.append(sb, "messages (Default: true)", 2);
                this.append(sb, "If true, create scripts for a Messages interface rather than a Constants one", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourceBundle", 2);
                this.append(sb, "Shortcut for a single resourceBundle", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourceBundles", 2);
                this.append(sb, "The messages ResourceBundles used to generate the GWT i18n inteface", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeOut (Default: 10000)", 2);
                this.append(sb, "Timeout for i18nCreator execution in a dedicated JVM", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test".equals(this.goal)) {
            this.append(sb, "gwt:test", 0);
            this.append(sb, "Mimic surefire to run GWTTestCases during integration-test phase, until SUREFIRE-508 is fixed", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of ant-style exclusion patterns for GWT integration tests", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2);
                this.append(sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes (Default: **/*GwtTest.java)", 2);
                this.append(sb, "Comma separated list of ant-style inclusion patterns for GWT integration tests", 3);
                this.append(sb, "", 0);
                this.append(sb, "out (Default: target/www-test)", 2);
                this.append(sb, "output directory for code generated by GWT for tests", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsDirectory (Default: ${project.build.directory}/surefire-reports)", 2);
                this.append(sb, "Directory for test reports, defaults to surefire one to match the surefire-report plugin", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip", 2);
                this.append(sb, "Set this to 'true' to bypass unit tests entirely. Its use is NOT RECOMMENDED, especially if you enable it using the 'maven.test.skip' property, because maven.test.skip disables both running the tests and compiling the tests. Consider using the skipTests parameter instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipExec", 2);
                this.append(sb, "DEPRECATED This old parameter is just like skipTests, but bound to the old property maven.test.skip.exec. Use -DskipTests instead; it's shorter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipTests", 2);
                this.append(sb, "Set this to 'true' to skip running tests, but still compile them. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeOut (Default: 60)", 2);
                this.append(sb, "Time out for test execution in dedicated JVM", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

