/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.gwt.AbstractGwtModuleMojo;
import org.codehaus.mojo.gwt.NoSystemExitSecurityManager;
import org.codehaus.mojo.gwt.SystemExitSecurityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileMojo
extends AbstractGwtModuleMojo {
    private File outputDirectory;
    private String logLevel;
    private String style;
    private File gen;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"CompileMojo#execute()");
        Object compiler = this.getGwtCompilerInstance();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(compiler.getClass().getClassLoader());
        SecurityManager sm = System.getSecurityManager();
        System.setSecurityManager(new NoSystemExitSecurityManager(sm));
        try {
            for (String module : this.getModules()) {
                this.compile(module, compiler);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
            System.setSecurityManager(sm);
        }
    }

    private void compile(String module, Object compiler) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Compile GWT module " + module));
        List<String> args = this.getGwtCompilerArguments(module);
        try {
            this.getLog().debug((CharSequence)"invoke GWTCompiler#main(String[])");
            Method processArgs = compiler.getClass().getMethod("main", String[].class);
            processArgs.invoke(null, new Object[]{args.toArray(new String[args.size()])});
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SystemExitSecurityException) {
                SystemExitSecurityException sse = (SystemExitSecurityException)e.getTargetException();
                if (sse.getStatus() == 0) {
                    this.getLog().debug((CharSequence)"System.exit(0) has been intercepted --> ignored");
                }
                throw new MojoExecutionException("GWTCompiler failed");
            }
            throw new MojoExecutionException("GWTCompiler#main(String[]) failed.", (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("GWTCompiler#main(String[]) failed.", e);
        }
    }

    private ClassLoader getAlternateClassLoader() throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"CompileMojo#getAlternateClassLoader()");
        }
        URLClassLoader myClassLoader = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        URL[] originalUrls = myClassLoader.getURLs();
        URL[] urls = this.addProjectClasspathElements(originalUrls);
        for (int index = 0; index < originalUrls.length; ++index) {
            try {
                String url = originalUrls[index].toExternalForm();
                urls[index] = new File(url.substring("file:".length())).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Failed to convert original classpath to URL.", (Exception)e);
            }
        }
        if (this.getLog().isDebugEnabled()) {
            for (int i = 0; i < urls.length; ++i) {
                this.getLog().debug((CharSequence)("  URL:" + urls[i]));
            }
        }
        return new URLClassLoader(urls, myClassLoader.getParent());
    }

    protected Object getGwtCompilerInstance() throws MojoExecutionException {
        String compilerClassName = "com.google.gwt.dev.GWTCompiler";
        Class<?> compiler = null;
        ClassLoader loader = null;
        try {
            loader = this.getClassLoader();
            compiler = (Class<?>)loader.loadClass("com.google.gwt.dev.GWTCompiler").newInstance();
        }
        catch (Exception e) {
            try {
                loader = this.getAlternateClassLoader();
                compiler = loader.loadClass("com.google.gwt.dev.GWTCompiler");
            }
            catch (Exception ee) {
                throw new MojoExecutionException("Could not find GWTCompiler.", ee);
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("  Found class:" + compiler.getClass()));
        }
        return compiler;
    }

    protected List<String> getGwtCompilerArguments(String module) {
        LinkedList<String> args = new LinkedList<String>();
        args.add("-out");
        args.add(this.outputDirectory.getAbsolutePath());
        args.add("-logLevel");
        args.add(this.logLevel);
        args.add("-style");
        args.add(this.style);
        if (this.gen != null) {
            args.add("-gen");
            args.add(this.gen.getAbsolutePath());
        }
        args.add(module);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("  Invoking main with" + args));
        }
        return args;
    }
}

