/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGwtMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File generateDirectory;

    protected ClassLoader getProjectClassLoader() throws DependencyResolutionRequiredException, MalformedURLException {
        this.getLog().debug((CharSequence)"AbstractMojo#getProjectClassLoader()");
        List compile = this.project.getCompileClasspathElements();
        URL[] urls = new URL[compile.size()];
        int i = 0;
        for (Object object : compile) {
            urls[i] = object instanceof Artifact ? ((Artifact)object).getFile().toURI().toURL() : new File((String)object).toURI().toURL();
            ++i;
        }
        return new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
    }

    protected void addCompileSourceRoot(File path) {
        this.project.addCompileSourceRoot(path.getAbsolutePath());
    }

    public MavenProject getProject() {
        return this.project;
    }

    protected ClassLoader getClassLoader() throws MojoExecutionException {
        URLClassLoader myClassLoader = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        URL[] originalUrls = myClassLoader.getURLs();
        URL[] urls = this.addProjectClasspathElements(originalUrls);
        System.arraycopy(originalUrls, 0, urls, 0, originalUrls.length);
        if (this.getLog().isDebugEnabled()) {
            for (int i = 0; i < urls.length; ++i) {
                this.getLog().debug((CharSequence)("  URL:" + urls[i]));
            }
        }
        return new URLClassLoader(urls, myClassLoader.getParent());
    }

    protected URL[] addProjectClasspathElements(URL[] originalUrls) throws MojoExecutionException {
        List sources = this.project.getCompileSourceRoots();
        List resources = this.project.getResources();
        Set dependencies = this.project.getArtifacts();
        URL[] urls = new URL[originalUrls.length + sources.size() + resources.size() + dependencies.size() + 2];
        int i = originalUrls.length;
        this.getLog().debug((CharSequence)("add compile source roots to GWTCompiler classpath " + sources.size()));
        i = this.addClasspathElements(sources, urls, i);
        this.getLog().debug((CharSequence)("add resources to GWTCompiler classpath " + resources.size()));
        i = this.addClasspathElements(resources, urls, i);
        this.getLog().debug((CharSequence)("add project dependencies to GWTCompiler  classpath " + dependencies.size()));
        i = this.addClasspathElements(dependencies, urls, i);
        try {
            urls[i++] = this.generateDirectory.toURL();
            urls[i] = new File(this.project.getBuild().getOutputDirectory()).toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed to convert project.build.outputDirectory to URL", (Exception)e);
        }
        return urls;
    }

    protected int addClasspathElements(Collection<?> elements, URL[] urls, int startPosition) throws MojoExecutionException {
        for (Object object : elements) {
            try {
                urls[startPosition] = object instanceof Artifact ? ((Artifact)object).getFile().toURI().toURL() : (object instanceof Resource ? new File(((Resource)object).getDirectory()).toURI().toURL() : new File((String)object).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Failed to convert original classpath element " + object + " to URL.", (Exception)e);
            }
            ++startPosition;
        }
        return startPosition;
    }
}

