package org.codehaus.mojo.gwt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on gwt-maven-plugin. Call <pre>  mvn gwt:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sat Nov 22 18:38:55 CET 2008
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:gwt-maven-plugin:1.0", 0 );
        append( sb, "", 0 );

        append( sb, "Maven GWT Plugin 1.0", 0 );
        append( sb, "Maven plugin for the Google Web Toolkit.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 7 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "compile".equals( goal ) )
        {
            append( sb, "gwt:compile", 0 );
            append( sb, "Goal which compiles a GWT file.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "gen", 2 );
                append( sb, "The directory into which generated files will be written for review", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "logLevel (Default: WARN)", 2 );
                append( sb, "The level of logging detail: ERROR, WARN, INFO, TRACE, DEBUG, SPAM, or ALL", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module (Shortcut for modules)", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location of the file.", 3 );
                append( sb, "", 0 );

                append( sb, "style (Default: OBF)", 2 );
                append( sb, "Script output style: OBF[USCATED], PRETTY, or DETAILED", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "eclipse".equals( goal ) )
        {
            append( sb, "gwt:eclipse", 0 );
            append( sb, "Goal which install GWT artifacts in local repository.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "additionalPageParameters", 2 );
                append( sb, "Additional parameters to append to the module URL. For example, gwt-log users will set \'log_level=DEBUG\'", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module (Shortcut for modules)", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location of the file.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "eclipseTest".equals( goal ) )
        {
            append( sb, "gwt:eclipseTest", 0 );
            append( sb, "Goal which install GWT artifacts in local repository.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "additionalPageParameters", 2 );
                append( sb, "Additional parameters to append to the module URL. For example, gwt-log users will set \'log_level=DEBUG\'", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Comma separated list of ant-style exclusion patterns for GWT integration tests", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "includes (Default: **/*GwtTest.java)", 2 );
                append( sb, "Comma separated list of ant-style inclusion patterns for GWT integration tests", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module (Shortcut for modules)", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location of the file.", 3 );
                append( sb, "", 0 );

                append( sb, "testOutputDirectory (Default: ${project.build.directory}/www-test)", 2 );
                append( sb, "Location of the file.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "generateAsync".equals( goal ) )
        {
            append( sb, "gwt:generateAsync", 0 );
            append( sb, "Goal which generate Asyn interface.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: false)", 2 );
                append( sb, "Stop the build on error", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "rpcExtension", 2 );
                append( sb, "Extension for GWT-RPC. May be set to \'rpc\' if you want to map GWT-RPC calls to \'*.rpc\' in web.xml, for example when using Spring dispatch servlet to handle RPC requests.", 3 );
                append( sb, "", 0 );

                append( sb, "servicePattern (Default: **/*Service.java)", 2 );
                append( sb, "Pattern for GWT service interface", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "gwt:help", 0 );
            append( sb, "Display help information on gwt-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0gwt:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "i18n".equals( goal ) )
        {
            append( sb, "gwt:i18n", 0 );
            append( sb, "Execute the i18nCreator tool", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "constantsWithLookup", 2 );
                append( sb, "If true, create scripts for a ConstantsWithLookup interface rather than a Constants one", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "messages (Default: true)", 2 );
                append( sb, "If true, create scripts for a Messages interface rather than a Constants one", 3 );
                append( sb, "", 0 );

                append( sb, "resourceBundle", 2 );
                append( sb, "Shortcut for a single resourceBundle", 3 );
                append( sb, "", 0 );

                append( sb, "resourceBundles", 2 );
                append( sb, "The messages ResourceBundles used to generate the GWT i18n inteface", 3 );
                append( sb, "", 0 );

                append( sb, "timeOut (Default: 10000)", 2 );
                append( sb, "Timeout for i18nCreator execution in a dedicated JVM", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test".equals( goal ) )
        {
            append( sb, "gwt:test", 0 );
            append( sb, "Mimic surefire to run GWTTestCases during integration-test phase, until SUREFIRE-508 is fixed", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Comma separated list of ant-style exclusion patterns for GWT integration tests", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "includes (Default: **/*GwtTest.java)", 2 );
                append( sb, "Comma separated list of ant-style inclusion patterns for GWT integration tests", 3 );
                append( sb, "", 0 );

                append( sb, "out (Default: target/www-test)", 2 );
                append( sb, "output directory for code generated by GWT for tests", 3 );
                append( sb, "", 0 );

                append( sb, "reportsDirectory (Default: ${project.build.directory}/surefire-reports)", 2 );
                append( sb, "Directory for test reports, defaults to surefire one to match the surefire-report plugin", 3 );
                append( sb, "", 0 );

                append( sb, "skip", 2 );
                append( sb, "Set this to \'true\' to bypass unit tests entirely. Its use is NOT RECOMMENDED, especially if you enable it using the \'maven.test.skip\' property, because maven.test.skip disables both running the tests and compiling the tests. Consider using the skipTests parameter instead.", 3 );
                append( sb, "", 0 );

                append( sb, "skipExec", 2 );
                append( sb, "DEPRECATED This old parameter is just like skipTests, but bound to the old property maven.test.skip.exec. Use -DskipTests instead; it\'s shorter.", 3 );
                append( sb, "", 0 );

                append( sb, "skipTests", 2 );
                append( sb, "Set this to \'true\' to skip running tests, but still compile them. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3 );
                append( sb, "", 0 );

                append( sb, "timeOut (Default: 60)", 2 );
                append( sb, "Time out for test execution in dedicated JVM", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     */
    private List toLines( String text, int indent )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i] );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     */
    private void toLines( List lines, String line )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
