/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.groovy.execute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.groovy.execute.ExpressionEvaluatorImpl;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyMavenProjectAdapter
extends MavenProject {
    private final MavenSession session;
    private final Map properties;
    private final Map defaults;
    private Properties props;

    public GroovyMavenProjectAdapter(MavenProject project, MavenSession session, Map properties, Map defaults) {
        super(project);
        this.setParent(project.getParent());
        this.session = session;
        this.properties = properties;
        this.defaults = defaults;
    }

    public synchronized Properties getProperties() {
        if (this.props == null) {
            this.props = new EvaluatingProperties();
        }
        return this.props;
    }

    private class EvaluatingProperties
    extends Properties {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final ExpressionEvaluator evaluator = new ExpressionEvaluatorImpl(GroovyMavenProjectAdapter.access$000(GroovyMavenProjectAdapter.this), GroovyMavenProjectAdapter.this);

        public EvaluatingProperties() {
            this.putAll((Map<?, ?>)GroovyMavenProjectAdapter.this.getModel().getProperties());
            if (GroovyMavenProjectAdapter.this.properties != null) {
                this.putAll((Map<?, ?>)GroovyMavenProjectAdapter.this.properties);
            }
            if (this.log.isDebugEnabled() && !GroovyMavenProjectAdapter.this.props.isEmpty()) {
                this.log.debug("Properties: ");
                ArrayList<Object> keys = new ArrayList<Object>();
                keys.addAll(GroovyMavenProjectAdapter.this.props.keySet());
                Collections.sort(keys);
                Iterator iter = keys.iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    String value = GroovyMavenProjectAdapter.this.props.getProperty(name);
                    this.log.debug("    {} -> {}", (Object)name, (Object)value);
                }
            }
        }

        public Object lookup(Object key) {
            Object value = super.get(key);
            if (value == null) {
                value = GroovyMavenProjectAdapter.this.session.getExecutionProperties().get(key);
            }
            if (value == null && GroovyMavenProjectAdapter.this.defaults != null) {
                value = GroovyMavenProjectAdapter.this.defaults.get(key);
            }
            return value;
        }

        public Object get(Object key, boolean resolve) {
            Object value = this.lookup(key);
            if (resolve && value instanceof String) {
                try {
                    value = this.evaluator.evaluate((String)value);
                }
                catch (ExpressionEvaluationException e) {
                    throw new RuntimeException(e);
                }
            }
            return value;
        }

        public Object get(Object key) {
            return this.get(key, true);
        }

        public String getProperty(String name) {
            Object value = this.get(name);
            return value != null ? String.valueOf(value) : null;
        }
    }
}

