/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.groovy.compile;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.shared.io.scan.mapping.SourceMapping;
import org.apache.maven.shared.io.scan.mapping.SuffixMapping;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.mojo.groovy.CompilerMojoSupport;
import org.codehaus.mojo.groovy.feature.Component;
import org.codehaus.mojo.groovy.feature.Configuration;
import org.codehaus.mojo.groovy.runtime.ClassCompiler;

public abstract class AbstractCompileMojo
extends CompilerMojoSupport
implements ClassCompiler.Keys {
    private String sourceEncoding;
    private boolean verbose;
    private boolean debug;
    private boolean stacktrace;
    private int tolerance;
    private String scriptBaseClassname;
    private String defaultScriptExtension;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractCompileMojo() {
        super(ClassCompiler.KEY);
    }

    protected abstract Set getForcedCompileSources();

    protected void process(Component component) throws Exception {
        if (!$assertionsDisabled && component == null) {
            throw new AssertionError();
        }
        ClassCompiler compiler = (ClassCompiler)component;
        compiler.setTargetDirectory(this.getOutputDirectory());
        compiler.setClassPath(this.createClassPath());
        Configuration config = component.config();
        config.set("verbose", this.verbose);
        config.set("debug", this.debug);
        config.set("tolerance", this.tolerance);
        if (this.scriptBaseClassname != null) {
            config.set("scriptBaseClassname", (Object)this.scriptBaseClassname);
        }
        if (this.defaultScriptExtension != null) {
            config.set("defaultScriptExtension", (Object)this.defaultScriptExtension);
        }
        this.compile(compiler, this.sources != null ? this.sources : this.getDefaultSources());
    }

    protected void compile(ClassCompiler compiler, FileSet[] sources) throws Exception {
        int count;
        if (!$assertionsDisabled && compiler == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && sources == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < sources.length; ++i) {
            SourceMapping[] mappings = new SourceMapping[]{new SuffixMapping(".groovy", ".class"), new SuffixMapping(".java", ".class")};
            File[] files = this.scanForSources(sources[i], mappings);
            for (int j = 0; j < files.length; ++j) {
                this.log.debug(" + " + files[j]);
                compiler.add(files[j]);
            }
        }
        Set forced = this.getForcedCompileSources();
        if (!forced.isEmpty()) {
            this.log.debug("Forcing to compile:");
            Iterator iter = forced.iterator();
            while (iter.hasNext()) {
                File file = (File)iter.next();
                this.log.debug(" + " + file);
                compiler.add(file);
            }
        }
        if ((count = compiler.compile()) == 0) {
            this.log.info("No sources found to compile");
        } else {
            this.log.info("Compiled " + count + " Groovy source file" + (count > 1 ? "s" : ""));
        }
    }

    static {
        $assertionsDisabled = !AbstractCompileMojo.class.desiredAssertionStatus();
    }
}

