/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileInjector;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.flatten.Dependencies;
import org.codehaus.mojo.flatten.model.resolution.FlattenModelResolver;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="flatten", requiresProject=true, requiresDirectInvocation=false, executionStrategy="once-per-session", requiresDependencyCollection=ResolutionScope.RUNTIME)
public class FlattenMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="updatePomFile")
    private Boolean updatePomFile;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(property="flattenedPomFilename", defaultValue="flattened-pom.xml")
    private String flattenedPomFilename;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="false")
    private Boolean embedBuildProfileDependencies;
    @Component
    private ArtifactFactory artifactFactory;
    @Component(role=ModelBuilder.class)
    private DefaultModelBuilder modelBuilder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Generating flattened POM of project " + this.project.getId() + "..."));
        File originalPomFile = this.project.getFile();
        Model flattenedPom = this.createFlattenedPom(originalPomFile);
        String headerComment = this.extractHeaderComment(originalPomFile);
        File flattenedPomFile = new File(this.outputDirectory, this.flattenedPomFilename);
        this.writePom(flattenedPom, flattenedPomFile, headerComment);
        if (this.isUpdatePomFile()) {
            this.project.setFile(flattenedPomFile);
        }
    }

    protected String extractHeaderComment(File xmlFile) throws MojoExecutionException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            SaxHeaderCommentHandler handler = new SaxHeaderCommentHandler();
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.parse(xmlFile, (DefaultHandler)handler);
            return handler.getHeaderComment();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to parse XML from " + xmlFile, e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String extractHeaderCommentUsingXppNotWorking(File xmlFile) throws MojoExecutionException {
        xpp = new MXParser();
        inStream = null;
        try {
            inStream = new XmlStreamReader(xmlFile);
            xpp.setInput((Reader)inStream);
            eventType = -1;
            while (true) {
                eventType = xpp.next();
                System.out.println("XPP Event: " + eventType);
                if (eventType != 9) continue;
                var5_7 = xpp.getText();
                break;
            }
        }
        catch (XmlPullParserException e) {
            try {
                throw new MojoExecutionException("Failed to parse XML of " + xmlFile, (Exception)e);
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to read " + xmlFile, (Exception)e);
                }
            }
            catch (Throwable var6_9) {
                IOUtil.close(inStream);
                throw var6_9;
            }
        }
        IOUtil.close((Reader)inStream);
        return var5_7;
        {
            if (eventType != 2) ** continue;
            var5_8 = null;
        }
        IOUtil.close((Reader)inStream);
        return var5_8;
    }

    protected void writePom(Model pom, File pomFile, String headerComment) throws MojoExecutionException {
        boolean success;
        File parentFile = pomFile.getParentFile();
        if (!parentFile.exists() && !(success = parentFile.mkdirs())) {
            throw new MojoExecutionException("Failed to create directory " + pomFile.getParent());
        }
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        StringWriter stringWriter = new StringWriter(4096);
        try {
            pomWriter.write((Writer)stringWriter, pom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Internal I/O error!", (Exception)e);
        }
        StringBuffer buffer = stringWriter.getBuffer();
        if (!StringUtils.isEmpty((String)headerComment)) {
            int projectStartIndex = buffer.indexOf("<project");
            if (projectStartIndex >= 0) {
                buffer.insert(projectStartIndex, "<!--" + headerComment + "-->\n");
            } else {
                this.getLog().warn((CharSequence)"POM XML post-processing failed: no project tag found!");
            }
        }
        this.writeStringToFile(buffer.toString(), pomFile, pom.getModelEncoding());
    }

    protected void writeStringToFile(String data, File file, String encoding) throws MojoExecutionException {
        FileOutputStream outStream = null;
        OutputStreamWriter writer = null;
        try {
            outStream = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)outStream, encoding);
            writer.write(data);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Failed to write to " + file, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                IOUtil.close((OutputStream)outStream);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        IOUtil.close((OutputStream)outStream);
    }

    protected Model createFlattenedPom(File pomFile) throws MojoExecutionException {
        ModelBuildingResult buildingResult;
        FlattenModelResolver resolver = new FlattenModelResolver(this.localRepository, this.artifactFactory);
        DefaultModelBuildingRequest buildingRequest = new DefaultModelBuildingRequest().setPomFile(pomFile).setModelResolver((ModelResolver)resolver);
        try {
            ProfileInjector profileInjector = new ProfileInjector(){

                public void injectProfile(Model model, Profile profile, ModelBuildingRequest request, ModelProblemCollector problems) {
                }
            };
            ProfileSelector profileSelector = new ProfileSelector(){

                public List<Profile> getActiveProfiles(Collection<Profile> profiles, ProfileActivationContext context, ModelProblemCollector problems) {
                    ArrayList<Profile> activeProfiles = new ArrayList<Profile>(profiles.size());
                    for (Profile profile : profiles) {
                        Activation activation = profile.getActivation();
                        if (FlattenMojo.this.isEmbedBuildProfileDependencies() && !FlattenMojo.this.isBuildTimeDriven(activation)) continue;
                        activeProfiles.add(profile);
                    }
                    return activeProfiles;
                }
            };
            this.modelBuilder.setProfileInjector(profileInjector).setProfileSelector(profileSelector);
            buildingResult = this.modelBuilder.build((ModelBuildingRequest)buildingRequest);
        }
        catch (ModelBuildingException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        Model effectiveModel = buildingResult.getEffectiveModel();
        Model model = new Model();
        String modelEncoding = effectiveModel.getModelEncoding();
        if (StringUtils.isEmpty((String)modelEncoding)) {
            modelEncoding = "UTF-8";
        }
        model.setModelEncoding(modelEncoding);
        model.setModelVersion("4.0.0");
        model.setGroupId(effectiveModel.getGroupId());
        model.setArtifactId(effectiveModel.getArtifactId());
        model.setVersion(effectiveModel.getVersion());
        model.setPackaging(effectiveModel.getPackaging());
        if ("maven-plugin".equals(effectiveModel.getPackaging())) {
            model.setPrerequisites(effectiveModel.getPrerequisites());
        }
        model.setLicenses(effectiveModel.getLicenses());
        model.setRepositories(effectiveModel.getRepositories());
        List<Dependency> dependencies = this.createFlattenedDependencies(effectiveModel);
        model.setDependencies(dependencies);
        for (Profile profile : effectiveModel.getProfiles()) {
            if (this.isEmbedBuildProfileDependencies() && this.isBuildTimeDriven(profile.getActivation()) || this.isEmpty(profile.getDependencies()) && this.isEmpty(profile.getRepositories())) continue;
            Profile strippedProfile = new Profile();
            strippedProfile.setId(profile.getId());
            strippedProfile.setActivation(profile.getActivation());
            strippedProfile.setDependencies(profile.getDependencies());
            strippedProfile.setRepositories(profile.getRepositories());
            model.addProfile(strippedProfile);
        }
        return model;
    }

    private boolean isEmpty(Collection<?> collection) {
        if (collection == null) {
            return true;
        }
        return collection.isEmpty();
    }

    protected boolean isEmbedBuildProfileDependencies() {
        return this.embedBuildProfileDependencies;
    }

    protected boolean isBuildTimeDriven(Activation activation) {
        if (activation == null) {
            return true;
        }
        return StringUtils.isEmpty((String)activation.getJdk()) && activation.getOs() == null;
    }

    protected List<Dependency> createFlattenedDependencies(Model effectiveModel) {
        ArrayList<Dependency> flattenedDependencies = new ArrayList<Dependency>();
        this.createFlattenedDependencies(effectiveModel, flattenedDependencies);
        if (this.isEmbedBuildProfileDependencies()) {
            Model projectModel = this.project.getModel();
            Dependencies modelDependencies = new Dependencies();
            modelDependencies.addAll(projectModel.getDependencies());
            for (Profile profile : projectModel.getProfiles()) {
                if (!this.isBuildTimeDriven(profile.getActivation())) continue;
                List profileDependencies = profile.getDependencies();
                for (Dependency profileDependency : profileDependencies) {
                    if (!modelDependencies.contains(profileDependency)) continue;
                    flattenedDependencies.add(profileDependency);
                }
            }
            this.getLog().debug((CharSequence)("Resolved " + flattenedDependencies.size() + " dependency/-ies for flattened POM."));
        }
        return flattenedDependencies;
    }

    protected void createFlattenedDependencies(Model effectiveModel, List<Dependency> flattenedDependencies) {
        this.getLog().debug((CharSequence)("Resolving dependencies of " + effectiveModel.getId()));
        List projectDependencies = effectiveModel.getDependencies();
        for (Dependency projectDependency : projectDependencies) {
            Dependency flattenedDependency = this.createFlattenedDependency(projectDependency);
            if (flattenedDependency == null) continue;
            flattenedDependencies.add(flattenedDependency);
        }
    }

    protected Dependency createFlattenedDependency(Dependency projectDependency) {
        return "test".equals(projectDependency.getScope()) ? null : projectDependency;
    }

    protected boolean isUpdatePomFile() {
        if (this.updatePomFile == null) {
            return !this.project.getPackaging().equals("pom");
        }
        return this.updatePomFile;
    }

    private class SaxHeaderCommentHandler
    extends DefaultHandler2 {
        private boolean rootTagSeen = false;
        private String headerComment;

        public String getHeaderComment() {
            return this.headerComment;
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (!this.rootTagSeen) {
                if (this.headerComment == null) {
                    this.headerComment = new String(ch, start, length);
                } else {
                    FlattenMojo.this.getLog().warn((CharSequence)"Ignoring multiple XML header comment!");
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.rootTagSeen = true;
        }
    }
}

