/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.findbugs;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import java.util.ResourceBundle;
import org.apache.bcel.classfile.JavaClass;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.mojo.findbugs.EffortParameter;
import org.codehaus.mojo.findbugs.ThresholdParameter;

public final class Reporter
extends AbstractBugReporter {
    private static final String NOLINE_KEY = "report.findbugs.noline";
    private static final String COLUMN_LINE_KEY = "report.findbugs.column.line";
    private static final String COLUMN_BUG_KEY = "report.findbugs.column.bug";
    private static final String COLUMN_CATEGORY_KEY = "report.findbugs.column.category";
    private static final String COLUMN_DETAILS_KEY = "report.findbugs.column.details";
    private static final String REPORT_TITLE_KEY = "report.findbugs.reporttitle";
    private static final String LINKTITLE_KEY = "report.findbugs.linktitle";
    private static final String LINK_KEY = "report.findbugs.link";
    private static final String NAME_KEY = "report.findbugs.name";
    private static final String FILES_KEY = "report.findbugs.files";
    private static final String THRESHOLD_KEY = "report.findbugs.threshold";
    private static final String URL_SEPARATOR = "/";
    private static final String JXR_PATHPREFIX_KEY = "report.findbugs.jxrplugin.pathprefix";
    private static final String EFFORT_KEY = "report.findbugs.effort";
    private static final String DETAILSLINK_KEY = "report.findbugs.detailslink";
    private static final String VERSIONTITLE_KEY = "report.findbugs.versiontitle";
    private final transient Sink mSink;
    private final transient ResourceBundle mBundle;
    private final transient Log mLog;
    private final transient ThresholdParameter mThreshold;
    private final transient EffortParameter mEffort;
    private transient String mCurrentClassName;
    private transient boolean mIsCurrentClassReportOpened = false;
    private transient boolean mIsJXRReportEnabled = false;

    private Reporter() {
        this.mSink = null;
        this.mBundle = null;
        this.mLog = null;
        this.mThreshold = null;
        this.mEffort = null;
    }

    public Reporter(Sink pSink, ResourceBundle pBundle, Log pLog, ThresholdParameter pThreshold, boolean pIsJXRReportEnabled, EffortParameter pEffort) {
        if (pSink == null) {
            throw new IllegalArgumentException("pSink not allowed to be null");
        }
        if (pBundle == null) {
            throw new IllegalArgumentException("pBundle not allowed to be null");
        }
        if (pLog == null) {
            throw new IllegalArgumentException("pLog not allowed to be null");
        }
        if (pThreshold == null) {
            throw new IllegalArgumentException("pThreshold not allowed to be null");
        }
        if (pEffort == null) {
            throw new IllegalArgumentException("pEffort not allowed to be null");
        }
        this.mSink = pSink;
        this.mBundle = pBundle;
        this.mLog = pLog;
        this.mThreshold = pThreshold;
        this.mIsJXRReportEnabled = pIsJXRReportEnabled;
        this.mEffort = pEffort;
        this.initialiseReport();
    }

    private void initialiseReport() {
        this.mSink.head();
        this.mSink.title();
        this.mSink.text(this.getReportTitle());
        this.mSink.title_();
        this.mSink.head_();
        this.mSink.body();
        this.mSink.section1();
        this.mSink.sectionTitle1();
        this.mSink.text(this.getReportTitle());
        this.mSink.sectionTitle1_();
        this.mSink.paragraph();
        this.mSink.text(this.getReportLinkTitle() + " ");
        this.mSink.link(this.getFindBugsLink());
        this.mSink.text(this.getFindBugsName());
        this.mSink.link_();
        this.mSink.paragraph_();
        this.mSink.paragraph();
        this.mSink.text(this.getVersionTitle() + " ");
        this.mSink.italic();
        this.mSink.text(this.getFindBugsVersion());
        this.mSink.italic_();
        this.mSink.paragraph_();
        this.mSink.paragraph();
        this.mSink.text(this.getThresholdTitle() + " ");
        this.mSink.italic();
        this.mSink.text(this.mThreshold.getName());
        this.mSink.italic_();
        this.mSink.paragraph_();
        this.mSink.paragraph();
        this.mSink.text(this.getEffortTitle() + " ");
        this.mSink.italic();
        this.mSink.text(this.mEffort.getName());
        this.mSink.italic_();
        this.mSink.paragraph_();
        this.mSink.section1_();
        this.mSink.sectionTitle1();
        this.mSink.text(this.getFilesTitle());
        this.mSink.sectionTitle1_();
    }

    protected void doReportBug(BugInstance pBugInstance) {
        this.mLog.debug((CharSequence)("  Found a bug: " + pBugInstance.getMessage()));
        this.addBugReport(pBugInstance);
    }

    public void reportAnalysisError(AnalysisError pAnalysisError) {
        this.mLog.debug((CharSequence)("  Found an analysisError: " + pAnalysisError.getMessage()));
    }

    public void reportMissingClass(String pMissingClass) {
        this.mLog.debug((CharSequence)("  Found a missing class: " + pMissingClass));
    }

    public void finish() {
        this.mLog.debug((CharSequence)"Finished searching for bugs!");
        if (this.mIsCurrentClassReportOpened) {
            this.closeClassReportSection();
        }
        this.mSink.section1_();
        this.mSink.body_();
        this.mSink.flush();
        this.mSink.close();
    }

    public BugReporter getRealBugReporter() {
        return this;
    }

    public void observeClass(JavaClass clazz) {
        this.mLog.debug((CharSequence)("Observe class: " + clazz.getClassName()));
        this.mCurrentClassName = clazz.getClassName();
        if (this.mIsCurrentClassReportOpened) {
            this.closeClassReportSection();
        }
        this.mIsCurrentClassReportOpened = false;
    }

    protected void closeClassReportSection() {
        this.mSink.table_();
        this.mSink.section2_();
    }

    protected String getVersionTitle() {
        String versionTitle = this.mBundle.getString(VERSIONTITLE_KEY);
        return versionTitle;
    }

    protected String getFindBugsVersion() {
        return "1.0.0";
    }

    protected String getReportTitle() {
        String reportTitle = this.mBundle.getString(REPORT_TITLE_KEY);
        return reportTitle;
    }

    protected String getReportLinkTitle() {
        String reportLink = this.mBundle.getString(LINKTITLE_KEY);
        return reportLink;
    }

    protected String getFindBugsLink() {
        String link = this.mBundle.getString(LINK_KEY);
        return link;
    }

    protected String getFindBugsName() {
        String name = this.mBundle.getString(NAME_KEY);
        return name;
    }

    protected String getFilesTitle() {
        String fileTitle = this.mBundle.getString(FILES_KEY);
        return fileTitle;
    }

    protected String getThresholdTitle() {
        String threshholdTitle = this.mBundle.getString(THRESHOLD_KEY);
        return threshholdTitle;
    }

    protected String getEffortTitle() {
        String effortTitle = this.mBundle.getString(EFFORT_KEY);
        return effortTitle;
    }

    protected String getDetailsLink(String pType) {
        String link = this.mBundle.getString(DETAILSLINK_KEY) + "#" + pType;
        return link;
    }

    protected void addBugReport(BugInstance pBugInstance) {
        SourceLineAnnotation line = pBugInstance.getPrimarySourceLineAnnotation();
        BugPattern pattern = pBugInstance.getBugPattern();
        String lineNumber = this.valueForLine(line);
        String category = pattern.getCategory();
        String type = pattern.getType();
        if (!this.mIsCurrentClassReportOpened) {
            this.openClassReportSection();
            this.mIsCurrentClassReportOpened = true;
        }
        this.mSink.tableRow();
        this.mSink.tableCell();
        this.mSink.text(pBugInstance.getMessageWithoutPrefix());
        this.mSink.tableCell_();
        this.mSink.tableCell();
        this.mSink.text(category);
        this.mSink.tableCell_();
        this.mSink.tableCell();
        this.mSink.link(this.getDetailsLink(type));
        this.mSink.text(type);
        this.mSink.link_();
        this.mSink.tableCell_();
        this.mSink.tableCell();
        if (this.mIsJXRReportEnabled) {
            this.mSink.rawText(this.assembleJXRHyperlink(line, lineNumber));
        } else {
            this.mSink.text(lineNumber);
        }
        this.mSink.tableCell_();
        this.mSink.tableRow_();
    }

    protected String valueForLine(SourceLineAnnotation pLine) {
        int endLine;
        int startLine;
        String value = null;
        value = pLine == null ? this.mBundle.getString(NOLINE_KEY) : ((startLine = pLine.getStartLine()) == (endLine = pLine.getEndLine()) ? (startLine == -1 ? this.mBundle.getString(NOLINE_KEY) : String.valueOf(startLine)) : String.valueOf(startLine) + "-" + String.valueOf(endLine));
        return value;
    }

    protected String assembleJXRHyperlink(SourceLineAnnotation pLine, String pLineNumber) {
        String hyperlink = null;
        String prefix = this.mBundle.getString(JXR_PATHPREFIX_KEY);
        String path = prefix + URL_SEPARATOR + this.mCurrentClassName.replaceAll("[.]", URL_SEPARATOR);
        hyperlink = pLine == null ? "<a href=" + path + ".html>" + pLineNumber + "</a>" : "<a href=" + path + ".html#" + pLine.getStartLine() + ">" + pLineNumber + "</a>";
        return hyperlink;
    }

    protected void openClassReportSection() {
        String columnBugText = this.mBundle.getString(COLUMN_BUG_KEY);
        String columnBugCategory = this.mBundle.getString(COLUMN_CATEGORY_KEY);
        String columnDescriptionLink = this.mBundle.getString(COLUMN_DETAILS_KEY);
        String columnLineText = this.mBundle.getString(COLUMN_LINE_KEY);
        this.mSink.section2();
        this.mSink.sectionTitle2();
        this.mSink.text(this.mCurrentClassName);
        this.mSink.sectionTitle2_();
        this.mSink.table();
        this.mSink.tableRow();
        this.mSink.tableHeaderCell();
        this.mSink.text(columnBugText);
        this.mSink.tableHeaderCell_();
        this.mSink.tableHeaderCell();
        this.mSink.text(columnBugCategory);
        this.mSink.tableHeaderCell_();
        this.mSink.tableHeaderCell();
        this.mSink.text(columnDescriptionLink);
        this.mSink.tableHeaderCell_();
        this.mSink.tableHeaderCell();
        this.mSink.text(columnLineText);
        this.mSink.tableHeaderCell_();
        this.mSink.tableRow_();
    }
}

