/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.findbugs;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.FilterException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.mojo.findbugs.EffortParameter;
import org.codehaus.mojo.findbugs.Reporter;
import org.codehaus.mojo.findbugs.ThresholdParameter;
import org.codehaus.plexus.util.FileUtils;

public final class FindBugsMojo
extends AbstractMavenReport {
    private static final String PLUGIN_NAME = "findbugs";
    private static final String BUNDLE_NAME = "findbugs";
    private static final String NAME_KEY = "report.findbugs.name";
    private static final String DESCRIPTION_KEY = "report.findbugs.description";
    private static final String SOURCE_ROOT_KEY = "report.findbugs.sourceRoot";
    private static final String JAVA_SOURCES_KEY = "report.findbugs.javasources";
    private static final String JAVA_REGEX_PATTERN = "**/*.class";
    private static final String JXR_ARTIFACT_ID_KEY = "report.findbugs.jxrplugin.artifactid";
    private static final String FINDBUGS_COREPLUGIN = "report.findbugs.coreplugin";
    private transient String outputDirectory;
    private transient SiteRenderer siteRenderer;
    private transient File classFilesDirectory;
    private transient ArrayList pluginArtifacts;
    private transient DefaultArtifactRepository localRepository;
    private List remoteArtifactRepositories;
    private transient MavenProject project;
    private transient String threshold;
    private ArtifactResolver artifactResolver;
    private transient String includeFilterFile;
    private transient String excludeFilterFile;
    private transient String effort;
    private transient String visitors;
    private transient String omitVisitors;
    private transient String pluginList;
    static /* synthetic */ Class class$org$codehaus$mojo$findbugs$FindBugsMojo;

    public String getOutputName() {
        return "findbugs";
    }

    public String getName(Locale pLocale) {
        ResourceBundle bundle = FindBugsMojo.getBundle(pLocale);
        String name = bundle.getString(NAME_KEY);
        return name;
    }

    public String getDescription(Locale pLocale) {
        ResourceBundle bundle = FindBugsMojo.getBundle(pLocale);
        String description = bundle.getString(DESCRIPTION_KEY);
        return description;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean canGenerateReport() {
        return this.classFilesDirectory.exists();
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected void executeReport(Locale pLocale) throws MavenReportException {
        FindBugs findBugs = null;
        this.debugSourceDirectory(pLocale, this.classFilesDirectory);
        try {
            findBugs = this.initialiseFindBugs(pLocale, this.getJavaSources(pLocale, this.classFilesDirectory));
        }
        catch (IOException pException) {
            throw new MavenReportException("A java source file could not be added", (Exception)pException);
        }
        catch (DependencyResolutionRequiredException pException) {
            throw new MavenReportException("Failed executing FindBugs", (Exception)((Object)pException));
        }
        catch (FilterException pException) {
            throw new MavenReportException("Failed adding filters to FindBugs", (Exception)((Object)pException));
        }
        catch (ArtifactNotFoundException pException) {
            throw new MavenReportException("Did not find coreplugin", (Exception)((Object)pException));
        }
        catch (ArtifactResolutionException pException) {
            throw new MavenReportException("Failed to resolve coreplugin", (Exception)((Object)pException));
        }
        PrintStream tempOut = System.out;
        try {
            System.setOut(new VoidPrintStream());
            findBugs.execute();
        }
        catch (IOException pException) {
            throw new MavenReportException("Failed executing FindBugs", (Exception)pException);
        }
        catch (InterruptedException pException) {
            throw new MavenReportException("Failed executing FindBugs", (Exception)pException);
        }
        catch (Exception pException) {
            throw new MavenReportException("Failed executing FindBugs", pException);
        }
        finally {
            System.setOut(tempOut);
        }
    }

    protected FindBugs initialiseFindBugs(Locale pLocale, List pSourceFiles) throws DependencyResolutionRequiredException, IOException, FilterException, ArtifactNotFoundException, ArtifactResolutionException {
        Sink sink = this.getSink();
        ResourceBundle bundle = FindBugsMojo.getBundle(pLocale);
        Log log = this.getLog();
        EffortParameter effortParameter = this.getEffortParameter();
        Reporter bugReporter = this.initialiseReporter(sink, bundle, log, effortParameter);
        Project findBugsProject = new Project();
        this.addJavaSourcesToFindBugsProject(pSourceFiles, findBugsProject);
        this.addClasspathEntriesToFindBugsProject(findBugsProject);
        FindBugs findBugs = new FindBugs((BugReporter)bugReporter, findBugsProject);
        this.addPluginsToFindBugs(pLocale);
        UserPreferences preferences = UserPreferences.createDefaultUserPreferences();
        this.addVisitorsToFindBugs(preferences);
        findBugs.setUserPreferences(preferences);
        findBugs.setAnalysisFeatureSettings(effortParameter.getValue());
        this.addFiltersToFindBugs(findBugs);
        return findBugs;
    }

    protected Reporter initialiseReporter(Sink pSink, ResourceBundle pBundle, Log pLog, EffortParameter pEffortParameter) {
        ThresholdParameter thresholdParameter = ThresholdParameter.DEFAULT;
        if (this.threshold == null) {
            this.getLog().info((CharSequence)"  No threshold provided, using default threshold.");
        } else if (this.threshold.equals(ThresholdParameter.HIGH.getName())) {
            thresholdParameter = ThresholdParameter.HIGH;
            this.getLog().info((CharSequence)"  Using high threshold.");
        } else if (this.threshold.equals(ThresholdParameter.NORMAL.getName())) {
            thresholdParameter = ThresholdParameter.NORMAL;
            this.getLog().info((CharSequence)"  Using normal threshold.");
        } else if (this.threshold.equals(ThresholdParameter.LOW.getName())) {
            thresholdParameter = ThresholdParameter.LOW;
            this.getLog().info((CharSequence)"  Using low threshold.");
        } else if (this.threshold.equals(ThresholdParameter.EXP.getName())) {
            thresholdParameter = ThresholdParameter.EXP;
            this.getLog().info((CharSequence)"  Using exp threshold.");
        } else if (this.threshold.equals(ThresholdParameter.IGNORE.getName())) {
            thresholdParameter = ThresholdParameter.IGNORE;
            this.getLog().info((CharSequence)"  Using ignore threshold.");
        } else {
            this.getLog().info((CharSequence)"  Threshold not recognised, using default threshold");
        }
        boolean isJXRPluginEnabled = this.isJXRPluginEnabled(pBundle);
        Reporter bugReporter = new Reporter(pSink, pBundle, pLog, thresholdParameter, isJXRPluginEnabled, pEffortParameter);
        bugReporter.setPriorityThreshold(thresholdParameter.getValue());
        return bugReporter;
    }

    protected List getJavaSources(Locale pLocale, File pSourceDirectory) throws IOException {
        ArrayList sourceFiles = new ArrayList();
        if (pSourceDirectory.exists() && pSourceDirectory.isDirectory()) {
            List files = FileUtils.getFiles((File)pSourceDirectory, (String)JAVA_REGEX_PATTERN, null);
            sourceFiles.addAll(files);
        }
        this.debugJavaSources(pLocale, sourceFiles);
        return sourceFiles;
    }

    protected void addJavaSourcesToFindBugsProject(List pSourceFiles, Project pFindBugsProject) {
        Iterator iterator = pSourceFiles.iterator();
        while (iterator.hasNext()) {
            File currentSourceFile = (File)iterator.next();
            String filePath = currentSourceFile.getAbsolutePath();
            pFindBugsProject.addFile(filePath);
        }
    }

    protected void addClasspathEntriesToFindBugsProject(Project pFindBugsProject) throws DependencyResolutionRequiredException {
        List entries = this.getProject().getCompileClasspathElements();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            String currentEntry = (String)iterator.next();
            this.getLog().debug((CharSequence)("  Adding " + currentEntry + " to auxilary classpath"));
            pFindBugsProject.addAuxClasspathEntry(currentEntry);
        }
    }

    protected void addFiltersToFindBugs(FindBugs pFindBugs) throws IOException, FilterException {
        if (this.includeFilterFile != null) {
            if (new File(this.includeFilterFile).exists()) {
                pFindBugs.addFilter(this.includeFilterFile, true);
                this.getLog().info((CharSequence)("  Using bug include filter " + this.includeFilterFile));
            } else {
                this.getLog().info((CharSequence)("  No bug include filter " + this.includeFilterFile + " found"));
            }
        } else {
            this.getLog().info((CharSequence)"  No bug include filter.");
        }
        if (this.excludeFilterFile != null) {
            if (new File(this.excludeFilterFile).exists()) {
                pFindBugs.addFilter(this.excludeFilterFile, false);
                this.getLog().info((CharSequence)("  Using bug exclude filter " + this.excludeFilterFile));
            } else {
                this.getLog().info((CharSequence)("  No bug exclude filter " + this.excludeFilterFile + " found"));
            }
        } else {
            this.getLog().info((CharSequence)"  No bug exclude filter.");
        }
    }

    protected void addPluginsToFindBugs(Locale pLocale) throws ArtifactNotFoundException, ArtifactResolutionException {
        File[] plugins;
        File corepluginpath = this.getCorePluginPath(pLocale);
        this.getLog().info((CharSequence)("  coreplugin Jar is located at " + corepluginpath.toString()));
        if (this.pluginList != null) {
            this.getLog().info((CharSequence)"  Adding Plugins ");
            String[] pluginJars = this.pluginList.split(",");
            plugins = new File[pluginJars.length + 1];
            for (int i = 0; i < pluginJars.length; ++i) {
                String pluginFile = pluginJars[i].trim();
                if (!pluginFile.endsWith(".jar")) {
                    throw new IllegalArgumentException("Plugin File is not a Jar file: " + pluginFile);
                }
                this.getLog().info((CharSequence)("  Adding Plugin: " + pluginFile));
                plugins[i + 1] = new File(pluginFile);
            }
        } else {
            plugins = new File[1];
        }
        this.getLog().info((CharSequence)"  Done Adding Plugins");
        plugins[0] = corepluginpath;
        DetectorFactoryCollection.setPluginList((File[])plugins);
    }

    protected File getCorePluginPath(Locale pLocale) throws ArtifactNotFoundException, ArtifactResolutionException {
        Iterator it = ((AbstractList)this.pluginArtifacts).iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (!artifact.getArtifactId().equals(this.getCorePlugin(pLocale))) continue;
            this.artifactResolver.resolve(artifact, this.remoteArtifactRepositories, (ArtifactRepository)this.localRepository);
            return artifact.getFile();
        }
        return null;
    }

    protected String getCorePlugin(Locale pLocale) {
        ResourceBundle bundle = FindBugsMojo.getBundle(pLocale);
        String corePluginName = bundle.getString(FINDBUGS_COREPLUGIN);
        return corePluginName;
    }

    protected void addVisitorsToFindBugs(UserPreferences preferences) {
        if (this.visitors != null || this.omitVisitors != null) {
            String[] visitorList;
            boolean enableVisitor = true;
            if (this.omitVisitors != null) {
                enableVisitor = false;
                visitorList = this.omitVisitors.split(",");
                this.getLog().info((CharSequence)("  Omitting visitors : " + this.omitVisitors));
            } else {
                visitorList = this.visitors.split(",");
                this.getLog().info((CharSequence)("  Including visitors : " + this.visitors));
                preferences.enableAllDetectors(false);
            }
            for (int i = 0; i < visitorList.length; ++i) {
                String visitorName = visitorList[i].trim();
                DetectorFactory factory = DetectorFactoryCollection.instance().getFactory(visitorName);
                if (factory == null) {
                    throw new IllegalArgumentException("Unknown detector: " + visitorName);
                }
                preferences.enableDetector(factory, enableVisitor);
            }
        }
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected static ResourceBundle getBundle(Locale pLocale) {
        ClassLoader loader = (class$org$codehaus$mojo$findbugs$FindBugsMojo == null ? (class$org$codehaus$mojo$findbugs$FindBugsMojo = FindBugsMojo.class$("org.codehaus.mojo.findbugs.FindBugsMojo")) : class$org$codehaus$mojo$findbugs$FindBugsMojo).getClassLoader();
        ResourceBundle bundle = ResourceBundle.getBundle("findbugs", pLocale, loader);
        return bundle;
    }

    protected EffortParameter getEffortParameter() {
        EffortParameter effortParameter = EffortParameter.DEFAULT;
        if (this.effort == null) {
            this.getLog().info((CharSequence)"  No effort provided, using default effort.");
        } else if (this.effort.equals(EffortParameter.MAX.getName())) {
            effortParameter = EffortParameter.MAX;
            this.getLog().info((CharSequence)"  Using maximum effort.");
        } else if (this.effort.equals(EffortParameter.DEFAULT.getName())) {
            effortParameter = EffortParameter.DEFAULT;
            this.getLog().info((CharSequence)"  Using normal effort.");
        } else if (this.effort.equals(EffortParameter.MIN.getName())) {
            effortParameter = EffortParameter.MIN;
            this.getLog().info((CharSequence)"  Using minimum effort.");
        } else {
            this.getLog().info((CharSequence)"  Effort not recognised, using default effort");
        }
        return effortParameter;
    }

    protected void debugSourceDirectory(Locale pLocale, File pSourceDirectory) {
        ResourceBundle bundle = FindBugsMojo.getBundle(pLocale);
        String sourceRootMessage = bundle.getString(SOURCE_ROOT_KEY);
        this.getLog().debug((CharSequence)("  " + sourceRootMessage));
        this.getLog().debug((CharSequence)("    " + pSourceDirectory.getAbsolutePath()));
    }

    protected void debugJavaSources(Locale pLocale, List pSourceFiles) {
        ResourceBundle bundle = FindBugsMojo.getBundle(pLocale);
        String javaSourceMessage = bundle.getString(JAVA_SOURCES_KEY);
        this.getLog().debug((CharSequence)("  " + javaSourceMessage));
        Iterator iterator = pSourceFiles.iterator();
        while (iterator.hasNext()) {
            File currentFile = (File)iterator.next();
            this.getLog().debug((CharSequence)("    " + currentFile.getAbsolutePath()));
        }
    }

    protected boolean isJXRPluginEnabled(ResourceBundle pBundle) {
        boolean isEnabled = false;
        String artifactId = pBundle.getString(JXR_ARTIFACT_ID_KEY);
        List reportPlugins = this.getProject().getReportPlugins();
        Iterator iterator = reportPlugins.iterator();
        while (iterator.hasNext()) {
            ReportPlugin currentPlugin = (ReportPlugin)iterator.next();
            String currentArtifactId = currentPlugin.getArtifactId();
            if (!artifactId.equals(currentArtifactId)) continue;
            isEnabled = true;
        }
        return isEnabled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class VoidPrintStream
    extends PrintStream {
        public VoidPrintStream() {
            super(new PrintStream(System.out));
        }

        public void println(String s) {
        }
    }
}

