/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.enforcer.JarUtils;

public class Hasher {
    private final String classFilePath;

    public Hasher(String classFilePath) {
        this.classFilePath = classFilePath;
    }

    public String generateHash(Artifact artifact) {
        File artifactFile = artifact.getFile();
        try {
            if (artifactFile.isDirectory()) {
                return this.hashForFileInDirectory(artifactFile);
            }
            if (JarUtils.isJarFile(artifact)) {
                return this.hashForFileInJar(artifactFile);
            }
            throw new IllegalArgumentException("Expected either a directory or a jar file, but instead received: " + artifactFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem calculating hash for " + artifact + " " + this.classFilePath, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String hashForFileInDirectory(File artifactFile) throws IOException {
        String string;
        File classFile = new File(artifactFile, this.classFilePath);
        FileInputStream inputStream = new FileInputStream(classFile);
        try {
            string = DigestUtils.md5Hex((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            this.closeAll(inputStream);
            throw throwable;
        }
        this.closeAll(inputStream);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String hashForFileInJar(File artifactFile) throws IOException {
        String string;
        JarFile jar = new JarFile(artifactFile);
        InputStream inputStream = jar.getInputStream(jar.getEntry(this.classFilePath));
        try {
            string = DigestUtils.md5Hex((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            this.closeAll(inputStream, jar);
            throw throwable;
        }
        this.closeAll(inputStream, jar);
        return string;
    }

    private void closeAll(Closeable ... closeables) throws IOException {
        IOException firstException = null;
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException exception) {
                if (firstException != null) continue;
                firstException = exception;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }
}

