/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.enchanter;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import javax.script.ScriptEngine;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.enchanter.AbstractEnchanterMojo;
import org.codehaus.mojo.enchanter.StreamConnection;
import org.codehaus.plexus.util.IOUtil;

public class EnchanterScriptingMojo
extends AbstractEnchanterMojo {
    private File[] files = new File[0];

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.loadUserInfoFromSettings();
        if (this.files.length == 0) {
            this.getLog().warn((CharSequence)"No script to run");
            return;
        }
        FileReader reader = null;
        StreamConnection stream = null;
        try {
            stream = this.getStreamConnection();
            ScriptEngine engine = this.getScriptEngine();
            engine.put("conn", stream);
            engine.put("host", this.host);
            engine.put("username", this.username);
            engine.put("password", this.password);
            for (File script : this.files) {
                reader = new FileReader(script);
                engine.eval(reader);
                IOUtil.close((Reader)reader);
                reader = null;
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error in script execution.", e);
        }
        finally {
            IOUtil.close(reader);
            if (stream != null) {
                try {
                    stream.disconnect();
                }
                catch (Exception e) {}
            }
        }
    }

    protected ScriptEngine getScriptEngine() throws MojoExecutionException {
        if (this.files.length != 0) {
            return this.getScriptEngine(this.files[0]);
        }
        return null;
    }
}

