/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.enchanter;

import hidden.org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import hidden.org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import java.io.File;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.enchanter.ConnectionLibrary;
import org.codehaus.mojo.enchanter.StreamConnection;
import org.codehaus.mojo.enchanter.impl.DefaultStreamConnection;
import org.codehaus.mojo.enchanter.impl.GanymedSSHLibrary;
import org.codehaus.mojo.enchanter.impl.TelnetConnectionLibrary;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractEnchanterMojo
extends AbstractMojo {
    protected String connectionType;
    protected String host;
    protected String username;
    protected String password;
    protected MavenProject project;
    private Settings settings;
    private String settingsKey;
    private SecDispatcher securityDispatcher;

    protected ScriptEngine getScriptEngine(File script) throws MojoExecutionException {
        String fileExt = FileUtils.getExtension((String)script.getName());
        ScriptEngine engine = new ScriptEngineManager().getEngineByExtension(fileExt);
        if (engine == null) {
            throw new MojoExecutionException("Scripting engine not found for: " + script);
        }
        return engine;
    }

    protected StreamConnection getStreamConnection() throws MojoExecutionException {
        if ("ssh".equals(this.connectionType)) {
            return this.createSshStreamConnection();
        }
        if ("telnet".equals(this.connectionType)) {
            return this.createTelnetStreamConnection();
        }
        throw new MojoExecutionException("Invalid connection type: " + this.connectionType);
    }

    private StreamConnection createTelnetStreamConnection() {
        DefaultStreamConnection streamConnection = new DefaultStreamConnection();
        TelnetConnectionLibrary connLib = new TelnetConnectionLibrary();
        streamConnection.setConnectionLibrary((ConnectionLibrary)connLib);
        return streamConnection;
    }

    private StreamConnection createSshStreamConnection() {
        DefaultStreamConnection streamConnection = new DefaultStreamConnection();
        GanymedSSHLibrary connLib = new GanymedSSHLibrary();
        streamConnection.setConnectionLibrary((ConnectionLibrary)connLib);
        return streamConnection;
    }

    protected void loadUserInfoFromSettings() throws MojoExecutionException {
        Server server;
        if ((this.username == null || this.password == null) && (server = this.settings.getServer(this.settingsKey)) != null) {
            if (this.username == null) {
                this.username = server.getUsername();
            }
            if (this.password == null && server.getPassword() != null) {
                try {
                    this.password = this.securityDispatcher.decrypt(server.getPassword());
                }
                catch (SecDispatcherException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
        }
        if (StringUtils.isBlank((String)this.username)) {
            throw new MojoExecutionException("username is required.");
        }
    }
}

