/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dita;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.dita.AbstractDitaMojo;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.cli.Commandline;

public class DitaVersionMojo
extends AbstractDitaMojo {
    private String versionName;
    private boolean displayDitaOTVersion;
    private String ditaotVersionPath;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipped");
            return;
        }
        this.setupDitaDirectory();
        if (this.displayDitaOTVersion) {
            this.displayDitaOTBuiltinVersion();
        }
        this.loadCustomVersion();
    }

    private void displayDitaOTBuiltinVersion() throws MojoExecutionException {
        Commandline cl = new Commandline("java");
        cl.setWorkingDirectory(this.project.getBasedir());
        this.setupDitaMainClass(cl);
        this.setupDitaArguments(cl);
        this.setupClasspathEnv(cl);
        this.executeCommandline(cl);
    }

    /*
     * Loose catch block
     */
    private void loadCustomVersion() throws MojoExecutionException {
        FileInputStream is;
        String version;
        block6: {
            version = "UNKNOWN";
            is = null;
            try {
                File customVerionFile = new File(this.ditaDirectory, this.ditaotVersionPath);
                is = new FileInputStream(customVerionFile);
                Properties props = new Properties();
                props.load(is);
                if (props.get("version") == null) break block6;
                version = (String)props.get("version");
            }
            catch (FileNotFoundException e) {
                IOUtil.close(is);
            }
            catch (IOException e2) {
                throw new MojoExecutionException(e2.getMessage(), (Exception)e2);
                {
                    catch (Throwable throwable) {
                        IOUtil.close(is);
                        throw throwable;
                    }
                }
            }
        }
        IOUtil.close((InputStream)is);
        this.getLog().debug((CharSequence)("Set " + this.versionName + " to " + version));
        this.project.getProperties().put(this.versionName, version);
    }

    private void setupDitaArguments(Commandline cl) throws MojoExecutionException {
        cl.createArg().setValue("-version");
        cl.createArg().setValue("/ditadir:" + this.ditaDirectory);
    }
}

