/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.deployall;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.mojo.deployall.AbstractDeployMojo;

public class DeployPomsOnlyMojo
extends AbstractDeployMojo {
    private MavenProject project;
    private ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File sshFile;
        ArtifactRepository deploymentRepository = this.project.getDistributionManagementArtifactRepository();
        if (deploymentRepository == null) {
            String msg = "Deployment failed: repository element was not specified in the pom inside distributionManagement element. Skipping project: " + this.project.getId();
            this.getLog().info((CharSequence)msg);
            return;
        }
        String protocol = deploymentRepository.getProtocol();
        if (protocol.equals("scp") && !(sshFile = new File(System.getProperty("user.home"), ".ssh")).exists()) {
            sshFile.mkdirs();
        }
        File pomFile = this.project.getFile();
        Artifact artifact = this.artifactFactory.createBuildArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "pom");
        artifact.setFile(pomFile);
        ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pomFile);
        artifact.addMetadata((ArtifactMetadata)metadata);
        try {
            this.getDeployer().deploy(pomFile, artifact, deploymentRepository, this.getLocalRepository());
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

