/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dependency;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.dependency.ArtifactItem;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public abstract class AbstractFromConfigurationMojo
extends AbstractMojo {
    private ArtifactFactory factory;
    private ArtifactResolver resolver;
    private ArtifactRepository local;
    private List remoteRepos;
    private File outputDirectory;
    protected ArchiverManager archiverManager;
    private ArrayList artifactItems;
    protected MavenProject project;

    protected ArrayList getArtifactItems() throws MojoExecutionException {
        Iterator iter = ((AbstractList)this.artifactItems).iterator();
        while (iter.hasNext()) {
            ArtifactItem artifactItem = (ArtifactItem)iter.next();
            this.getLog().info((CharSequence)("Configured Artifact: " + artifactItem.toString()));
            if (artifactItem.getOutputDirectory() == null) {
                artifactItem.setOutputDirectory(this.outputDirectory);
            }
            artifactItem.getOutputDirectory().mkdirs();
        }
        return this.artifactItems;
    }

    protected Artifact getArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        String classifier;
        if (artifactItem.getVersion() == null) {
            this.fillArtifactVersionFromDependencyManagement(artifactItem);
            if (artifactItem.getVersion() == null) {
                throw new MojoExecutionException("Unable to find artifact version of " + artifactItem.getGroupId() + ":" + artifactItem.getArtifactId() + " in project's dependency management.");
            }
        }
        Artifact artifact = (classifier = artifactItem.getClassifier()) == null || classifier.equals("") ? this.factory.createArtifact(artifactItem.getGroupId(), artifactItem.getArtifactId(), artifactItem.getVersion(), "provided", artifactItem.getType()) : this.factory.createArtifactWithClassifier(artifactItem.getGroupId(), artifactItem.getArtifactId(), artifactItem.getVersion(), artifactItem.getType(), artifactItem.getClassifier());
        try {
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact.", (Exception)((Object)e));
        }
        return artifact;
    }

    private void fillArtifactVersionFromDependencyManagement(ArtifactItem artifact) {
        this.getLog().debug((CharSequence)"Attempting to find missing version from dependency management.");
        List list = this.project.getDependencyManagement().getDependencies();
        for (int i = 0; i < list.size(); ++i) {
            Dependency dependency = (Dependency)list.get(i);
            if (!dependency.getGroupId().equals(artifact.getGroupId()) || !dependency.getArtifactId().equals(artifact.getArtifactId()) || !dependency.getType().equals(artifact.getType())) continue;
            this.getLog().debug((CharSequence)("Found missing version: " + dependency.getVersion()));
            artifact.setVersion(dependency.getVersion());
        }
    }
}

