package org.codehaus.mojo.dbunit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on dbunit-maven-plugin.<br/> Call <pre>  mvn dbunit:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Tue Jul 14 19:39:31 CEST 2009
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:dbunit-maven-plugin:1.0-beta-3", 0 );
        append( sb, "", 0 );

        append( sb, "DbUnit Plugin", 0 );
        append( sb, "Use this plugin to invoke DbUnit utilities", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 4 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "compare".equals( goal ) )
        {
            append( sb, "dbunit:compare", 0 );
            append( sb, "Execute DbUnit Compare operation", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "dataTypeFactoryName (Default: org.dbunit.dataset.datatype.DefaultDataTypeFactory)", 2 );
                append( sb, "Set the DataType factory to add support for non-standard database vendor data types.", 3 );
                append( sb, "", 0 );

                append( sb, "datatypeWarning (Default: false)", 2 );
                append( sb, "Enable or disable the warning message displayed when DbUnit encounter an unsupported data type.", 3 );
                append( sb, "", 0 );

                append( sb, "driver", 2 );
                append( sb, "The class name of the JDBC driver to be used.", 3 );
                append( sb, "", 0 );

                append( sb, "escapePattern", 2 );
                append( sb, "escapePattern", 3 );
                append( sb, "", 0 );

                append( sb, "format (Default: xml)", 2 );
                append( sb, "DataSet file format", 3 );
                append( sb, "", 0 );

                append( sb, "metadataHandlerName (Default: org.dbunit.database.DefaultMetadataHandler)", 2 );
                append( sb, "Class name of metadata handler.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "Database password. If not given, it will be looked up through settings.xml\'s server with ${settingsKey} as key", 3 );
                append( sb, "", 0 );

                append( sb, "queries", 2 );
                append( sb, "List of DbUnit\'s Query. See DbUnit\'s org.dbunit.ant.Query JavaDoc for details", 3 );
                append( sb, "", 0 );

                append( sb, "schema", 2 );
                append( sb, "The schema name that tables can be found under.", 3 );
                append( sb, "", 0 );

                append( sb, "settingsKey", 2 );
                append( sb, "Server\'s id in settings.xml to look up username and password. Default to ${url} if not given.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Skip the execution when true, very handy when using together with maven.test.skip.", 3 );
                append( sb, "", 0 );

                append( sb, "skipOracleRecycleBinTables (Default: false)", 2 );
                append( sb, "skipOracleRecycleBinTables", 3 );
                append( sb, "", 0 );

                append( sb, "sort", 2 );
                append( sb, "sort", 3 );
                append( sb, "", 0 );

                append( sb, "src", 2 );
                append( sb, "DataSet file", 3 );
                append( sb, "", 0 );

                append( sb, "supportBatchStatement (Default: false)", 2 );
                append( sb, "Enable or disable usage of JDBC batched statement by DbUnit", 3 );
                append( sb, "", 0 );

                append( sb, "tables", 2 );
                append( sb, "List of DbUnit\'s Table. See DbUnit\'s org.dbunit.ant.Table JavaDoc for details", 3 );
                append( sb, "", 0 );

                append( sb, "url", 2 );
                append( sb, "The JDBC URL for the database to access, e.g. jdbc:db2:SAMPLE.", 3 );
                append( sb, "", 0 );

                append( sb, "useQualifiedTableNames (Default: false)", 2 );
                append( sb, "Enable or disable multiple schemas support by prefixing table names with the schema name.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "Database username. If not given, it will be looked up through settings.xml\'s server with ${settingsKey} as key", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "export".equals( goal ) )
        {
            append( sb, "dbunit:export", 0 );
            append( sb, "Execute DbUnit Export operation", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "dataTypeFactoryName (Default: org.dbunit.dataset.datatype.DefaultDataTypeFactory)", 2 );
                append( sb, "Set the DataType factory to add support for non-standard database vendor data types.", 3 );
                append( sb, "", 0 );

                append( sb, "datatypeWarning (Default: false)", 2 );
                append( sb, "Enable or disable the warning message displayed when DbUnit encounter an unsupported data type.", 3 );
                append( sb, "", 0 );

                append( sb, "dest (Default: ${project.build.directory}/dbunit/export.xml)", 2 );
                append( sb, "Location of exported DataSet file", 3 );
                append( sb, "", 0 );

                append( sb, "doctype", 2 );
                append( sb, "doctype", 3 );
                append( sb, "", 0 );

                append( sb, "driver", 2 );
                append( sb, "The class name of the JDBC driver to be used.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding of exported data.", 3 );
                append( sb, "", 0 );

                append( sb, "escapePattern", 2 );
                append( sb, "escapePattern", 3 );
                append( sb, "", 0 );

                append( sb, "format (Default: xml)", 2 );
                append( sb, "DataSet file format", 3 );
                append( sb, "", 0 );

                append( sb, "metadataHandlerName (Default: org.dbunit.database.DefaultMetadataHandler)", 2 );
                append( sb, "Class name of metadata handler.", 3 );
                append( sb, "", 0 );

                append( sb, "ordered", 2 );
                append( sb, "Set to true to order exported data according to integrity constraints defined in DB.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "Database password. If not given, it will be looked up through settings.xml\'s server with ${settingsKey} as key", 3 );
                append( sb, "", 0 );

                append( sb, "queries", 2 );
                append( sb, "List of DbUnit\'s Query. See DbUnit\'s JavaDoc for details", 3 );
                append( sb, "", 0 );

                append( sb, "schema", 2 );
                append( sb, "The schema name that tables can be found under.", 3 );
                append( sb, "", 0 );

                append( sb, "settingsKey", 2 );
                append( sb, "Server\'s id in settings.xml to look up username and password. Default to ${url} if not given.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Skip the execution when true, very handy when using together with maven.test.skip.", 3 );
                append( sb, "", 0 );

                append( sb, "skipOracleRecycleBinTables (Default: false)", 2 );
                append( sb, "skipOracleRecycleBinTables", 3 );
                append( sb, "", 0 );

                append( sb, "supportBatchStatement (Default: false)", 2 );
                append( sb, "Enable or disable usage of JDBC batched statement by DbUnit", 3 );
                append( sb, "", 0 );

                append( sb, "tables", 2 );
                append( sb, "List of DbUnit\'s Table. See DbUnit\'s JavaDoc for details", 3 );
                append( sb, "", 0 );

                append( sb, "url", 2 );
                append( sb, "The JDBC URL for the database to access, e.g. jdbc:db2:SAMPLE.", 3 );
                append( sb, "", 0 );

                append( sb, "useQualifiedTableNames (Default: false)", 2 );
                append( sb, "Enable or disable multiple schemas support by prefixing table names with the schema name.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "Database username. If not given, it will be looked up through settings.xml\'s server with ${settingsKey} as key", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "dbunit:help", 0 );
            append( sb, "Display help information on dbunit-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0dbunit:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "operation".equals( goal ) )
        {
            append( sb, "dbunit:operation", 0 );
            append( sb, "Execute DbUnit\'s Database Operation with an external dataset file.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "dataTypeFactoryName (Default: org.dbunit.dataset.datatype.DefaultDataTypeFactory)", 2 );
                append( sb, "Set the DataType factory to add support for non-standard database vendor data types.", 3 );
                append( sb, "", 0 );

                append( sb, "datatypeWarning (Default: false)", 2 );
                append( sb, "Enable or disable the warning message displayed when DbUnit encounter an unsupported data type.", 3 );
                append( sb, "", 0 );

                append( sb, "driver", 2 );
                append( sb, "The class name of the JDBC driver to be used.", 3 );
                append( sb, "", 0 );

                append( sb, "escapePattern", 2 );
                append( sb, "escapePattern", 3 );
                append( sb, "", 0 );

                append( sb, "format (Default: xml)", 2 );
                append( sb, "Dataset file format type. Valid types are: flat, xml, csv, and dtd", 3 );
                append( sb, "", 0 );

                append( sb, "metadataHandlerName (Default: org.dbunit.database.DefaultMetadataHandler)", 2 );
                append( sb, "Class name of metadata handler.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "Database password. If not given, it will be looked up through settings.xml\'s server with ${settingsKey} as key", 3 );
                append( sb, "", 0 );

                append( sb, "schema", 2 );
                append( sb, "The schema name that tables can be found under.", 3 );
                append( sb, "", 0 );

                append( sb, "settingsKey", 2 );
                append( sb, "Server\'s id in settings.xml to look up username and password. Default to ${url} if not given.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Skip the execution when true, very handy when using together with maven.test.skip.", 3 );
                append( sb, "", 0 );

                append( sb, "skipOracleRecycleBinTables (Default: false)", 2 );
                append( sb, "skipOracleRecycleBinTables", 3 );
                append( sb, "", 0 );

                append( sb, "src", 2 );
                append( sb, "DataSet file", 3 );
                append( sb, "", 0 );

                append( sb, "supportBatchStatement (Default: false)", 2 );
                append( sb, "Enable or disable usage of JDBC batched statement by DbUnit", 3 );
                append( sb, "", 0 );

                append( sb, "transaction (Default: false)", 2 );
                append( sb, "When true, place the entired operation in one transaction", 3 );
                append( sb, "", 0 );

                append( sb, "type", 2 );
                append( sb, "Type of Database operation to perform. Supported types are UPDATE, INSERT, DELETE, DELETE_ALL, REFRESH, CLEAN_INSERT, MSSQL_INSERT, MSSQL_REFRESH, MSSQL_CLEAN_INSERT", 3 );
                append( sb, "", 0 );

                append( sb, "url", 2 );
                append( sb, "The JDBC URL for the database to access, e.g. jdbc:db2:SAMPLE.", 3 );
                append( sb, "", 0 );

                append( sb, "useQualifiedTableNames (Default: false)", 2 );
                append( sb, "Enable or disable multiple schemas support by prefixing table names with the schema name.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "Database username. If not given, it will be looked up through settings.xml\'s server with ${settingsKey} as key", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
