/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dbunit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:dbunit-maven-plugin:1.0-beta-2", 0);
        this.append(sb, "", 0);
        this.append(sb, "DbUnit Plugin 1.0-beta-2", 0);
        this.append(sb, "Use this plugin to invoke DbUnit utilities", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "compare".equals(this.goal)) {
            this.append(sb, "dbunit:compare", 0);
            this.append(sb, "Execute DbUnit Compare operation", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "dataTypeFactoryName (Default: org.dbunit.dataset.datatype.DefaultDataTypeFactory)", 2);
                this.append(sb, "Set the DataType factory to add support for non-standard database vendor data types.", 3);
                this.append(sb, "", 0);
                this.append(sb, "datatypeWarning (Default: false)", 2);
                this.append(sb, "Enable or disable the warning message displayed when DbUnit encounter an unsupported data type.", 3);
                this.append(sb, "", 0);
                this.append(sb, "driver", 2);
                this.append(sb, "The class name of the JDBC driver to be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapePattern", 2);
                this.append(sb, "escapePattern", 3);
                this.append(sb, "", 0);
                this.append(sb, "format (Default: xml)", 2);
                this.append(sb, "DataSet file format", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "Database password. If not given, it will be looked up through settings.xml's server with ${settingsKey} as key", 3);
                this.append(sb, "", 0);
                this.append(sb, "queries", 2);
                this.append(sb, "List of DbUnit's Query. See DbUnit's org.dbunit.ant.Query JavaDoc for details", 3);
                this.append(sb, "", 0);
                this.append(sb, "schema", 2);
                this.append(sb, "The schema name that tables can be found under.", 3);
                this.append(sb, "", 0);
                this.append(sb, "settingsKey", 2);
                this.append(sb, "Server's id in settings.xml to look up username and password. Default to ${url} if not given.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution when true, very handy when using together with maven.test.skip.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipOracleRecycleBinTables (Default: false)", 2);
                this.append(sb, "skipOracleRecycleBinTables", 3);
                this.append(sb, "", 0);
                this.append(sb, "sort", 2);
                this.append(sb, "sort", 3);
                this.append(sb, "", 0);
                this.append(sb, "src", 2);
                this.append(sb, "DataSet file", 3);
                this.append(sb, "", 0);
                this.append(sb, "supportBatchStatement (Default: false)", 2);
                this.append(sb, "Enable or disable usage of JDBC batched statement by DbUnit", 3);
                this.append(sb, "", 0);
                this.append(sb, "tables", 2);
                this.append(sb, "List of DbUnit's Table. See DbUnit's org.dbunit.ant.Table JavaDoc for details", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "The JDBC URL for the database to access, e.g. jdbc:db2:SAMPLE.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useQualifiedTableNames (Default: false)", 2);
                this.append(sb, "Enable or disable multiple schemas support by prefixing table names with the schema name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Database username. If not given, it will be looked up through settings.xml's server with ${settingsKey} as key", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "export".equals(this.goal)) {
            this.append(sb, "dbunit:export", 0);
            this.append(sb, "Execute DbUnit Export operation", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "dataTypeFactoryName (Default: org.dbunit.dataset.datatype.DefaultDataTypeFactory)", 2);
                this.append(sb, "Set the DataType factory to add support for non-standard database vendor data types.", 3);
                this.append(sb, "", 0);
                this.append(sb, "datatypeWarning (Default: false)", 2);
                this.append(sb, "Enable or disable the warning message displayed when DbUnit encounter an unsupported data type.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dest (Default: ${project.build.directory}/dbunit/export.xml)", 2);
                this.append(sb, "Location of exported DataSet file", 3);
                this.append(sb, "", 0);
                this.append(sb, "doctype", 2);
                this.append(sb, "doctype", 3);
                this.append(sb, "", 0);
                this.append(sb, "driver", 2);
                this.append(sb, "The class name of the JDBC driver to be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding of exported data.", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapePattern", 2);
                this.append(sb, "escapePattern", 3);
                this.append(sb, "", 0);
                this.append(sb, "format (Default: xml)", 2);
                this.append(sb, "DataSet file format", 3);
                this.append(sb, "", 0);
                this.append(sb, "ordered", 2);
                this.append(sb, "Set to true to order exported data according to integrity constraints defined in DB.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "Database password. If not given, it will be looked up through settings.xml's server with ${settingsKey} as key", 3);
                this.append(sb, "", 0);
                this.append(sb, "queries", 2);
                this.append(sb, "List of DbUnit's Query. See DbUnit's JavaDoc for details", 3);
                this.append(sb, "", 0);
                this.append(sb, "schema", 2);
                this.append(sb, "The schema name that tables can be found under.", 3);
                this.append(sb, "", 0);
                this.append(sb, "settingsKey", 2);
                this.append(sb, "Server's id in settings.xml to look up username and password. Default to ${url} if not given.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution when true, very handy when using together with maven.test.skip.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipOracleRecycleBinTables (Default: false)", 2);
                this.append(sb, "skipOracleRecycleBinTables", 3);
                this.append(sb, "", 0);
                this.append(sb, "supportBatchStatement (Default: false)", 2);
                this.append(sb, "Enable or disable usage of JDBC batched statement by DbUnit", 3);
                this.append(sb, "", 0);
                this.append(sb, "tables", 2);
                this.append(sb, "List of DbUnit's Table. See DbUnit's JavaDoc for details", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "The JDBC URL for the database to access, e.g. jdbc:db2:SAMPLE.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useQualifiedTableNames (Default: false)", 2);
                this.append(sb, "Enable or disable multiple schemas support by prefixing table names with the schema name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Database username. If not given, it will be looked up through settings.xml's server with ${settingsKey} as key", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "dbunit:help", 0);
            this.append(sb, "Display help information on dbunit-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0dbunit:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "operation".equals(this.goal)) {
            this.append(sb, "dbunit:operation", 0);
            this.append(sb, "Execute DbUnit's Database Operation with an external dataset file.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "dataTypeFactoryName (Default: org.dbunit.dataset.datatype.DefaultDataTypeFactory)", 2);
                this.append(sb, "Set the DataType factory to add support for non-standard database vendor data types.", 3);
                this.append(sb, "", 0);
                this.append(sb, "datatypeWarning (Default: false)", 2);
                this.append(sb, "Enable or disable the warning message displayed when DbUnit encounter an unsupported data type.", 3);
                this.append(sb, "", 0);
                this.append(sb, "driver", 2);
                this.append(sb, "The class name of the JDBC driver to be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapePattern", 2);
                this.append(sb, "escapePattern", 3);
                this.append(sb, "", 0);
                this.append(sb, "format (Default: xml)", 2);
                this.append(sb, "Dataset file format type. Valid types are: flat, xml, csv, and dtd", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "Database password. If not given, it will be looked up through settings.xml's server with ${settingsKey} as key", 3);
                this.append(sb, "", 0);
                this.append(sb, "schema", 2);
                this.append(sb, "The schema name that tables can be found under.", 3);
                this.append(sb, "", 0);
                this.append(sb, "settingsKey", 2);
                this.append(sb, "Server's id in settings.xml to look up username and password. Default to ${url} if not given.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution when true, very handy when using together with maven.test.skip.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipOracleRecycleBinTables (Default: false)", 2);
                this.append(sb, "skipOracleRecycleBinTables", 3);
                this.append(sb, "", 0);
                this.append(sb, "src", 2);
                this.append(sb, "DataSet file", 3);
                this.append(sb, "", 0);
                this.append(sb, "supportBatchStatement (Default: false)", 2);
                this.append(sb, "Enable or disable usage of JDBC batched statement by DbUnit", 3);
                this.append(sb, "", 0);
                this.append(sb, "transaction (Default: false)", 2);
                this.append(sb, "When true, place the entired operation in one transaction", 3);
                this.append(sb, "", 0);
                this.append(sb, "type", 2);
                this.append(sb, "Type of Database operation to perform. Supported types are UPDATE, INSERT, DELETE, DELETE_ALL, REFRESH, CLEAN_INSERT, MSSQL_INSERT, MSSQL_REFRESH, MSSQL_CLEAN_INSERT", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "The JDBC URL for the database to access, e.g. jdbc:db2:SAMPLE.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useQualifiedTableNames (Default: false)", 2);
                this.append(sb, "Enable or disable multiple schemas support by prefixing table names with the schema name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Database username. If not given, it will be looked up through settings.xml's server with ${settingsKey} as key", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

