/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dbunit;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.dbunit.AbstractDbUnitMojo;
import org.dbunit.ant.Export;
import org.dbunit.ant.Query;
import org.dbunit.ant.Table;
import org.dbunit.database.IDatabaseConnection;

public class ExportMojo
extends AbstractDbUnitMojo {
    protected File dest;
    protected String format;
    protected String doctype;
    protected Table[] tables;
    protected Query[] queries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip export execution");
            return;
        }
        super.execute();
        try {
            this.dest.getParentFile().mkdirs();
            IDatabaseConnection connection = this.createConnection();
            try {
                int i;
                Export export = new Export();
                for (i = 0; this.queries != null && i < this.queries.length; ++i) {
                    export.addQuery(this.queries[i]);
                }
                for (i = 0; this.tables != null && i < this.tables.length; ++i) {
                    export.addTable(this.tables[i]);
                }
                export.setDest(this.dest);
                export.setDoctype(this.doctype);
                export.setFormat(this.format);
                export.execute(connection);
            }
            finally {
                connection.close();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing export", e);
        }
    }
}

