/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dbunit;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.ForwardOnlyResultSetTableFactory;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.datatype.IDataTypeFactory;

public abstract class AbstractDbUnitMojo
extends AbstractMojo {
    protected String driver;
    protected String username;
    protected String password;
    protected String url;
    protected String schema;
    protected String dataTypeFactoryName = "org.dbunit.dataset.datatype.DefaultDataTypeFactory";
    protected boolean supportBatchStatement;
    protected boolean useQualifiedTableNames;
    protected boolean datatypeWarning;
    protected String escapePattern;
    protected boolean skip;
    private Settings settings;
    private String settingsKey;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.loadUserInfoFromSettings();
    }

    IDatabaseConnection createConnection() throws Exception {
        Connection conn;
        Class<?> dc = Class.forName(this.driver);
        Driver driverInstance = (Driver)dc.newInstance();
        Properties info = new Properties();
        info.put("user", this.username);
        if (this.password != null) {
            info.put("password", this.password);
        }
        if ((conn = driverInstance.connect(this.url, info)) == null) {
            throw new SQLException("No suitable Driver for " + this.url);
        }
        conn.setAutoCommit(true);
        DatabaseConnection connection = new DatabaseConnection(conn, this.schema);
        DatabaseConfig config = connection.getConfig();
        config.setFeature("http://www.dbunit.org/features/batchedStatements", this.supportBatchStatement);
        config.setFeature("http://www.dbunit.org/features/qualifiedTableNames", this.useQualifiedTableNames);
        config.setFeature("http://www.dbunit.org/features/datatypeWarning", this.datatypeWarning);
        config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)this.escapePattern);
        config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", (Object)new ForwardOnlyResultSetTableFactory());
        IDataTypeFactory dataTypeFactory = (IDataTypeFactory)Class.forName(this.dataTypeFactoryName).newInstance();
        config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)dataTypeFactory);
        return connection;
    }

    private void loadUserInfoFromSettings() throws MojoExecutionException {
        Server server;
        if (this.settingsKey == null) {
            this.settingsKey = this.url;
        }
        if ((this.username == null || this.password == null) && this.settings != null && (server = this.settings.getServer(this.settingsKey)) != null) {
            if (this.username == null) {
                this.username = server.getUsername();
            }
            if (this.password == null) {
                this.password = server.getPassword();
            }
        }
        if (this.username == null) {
            this.username = "";
        }
        if (this.password == null) {
            this.password = "";
        }
    }
}

