/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura.tasks;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.codehaus.mojo.cobertura.tasks.CommandLineArguments;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTask {
    protected CommandLineArguments cmdLineArgs;
    private Log log;
    private String maxmem;
    private List<Artifact> pluginClasspathList;
    private String taskClass;
    private boolean quiet;

    protected AbstractTask(String taskClassname) {
        this.taskClass = taskClassname;
        this.cmdLineArgs = new CommandLineArguments();
        this.maxmem = "64m";
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public String createClasspath() throws MojoExecutionException {
        StringBuffer cpBuffer = new StringBuffer();
        for (Artifact artifact : this.pluginClasspathList) {
            try {
                cpBuffer.append(File.pathSeparator).append(artifact.getFile().getCanonicalPath());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while creating the canonical path for '" + artifact.getFile() + "'.", (Exception)e);
            }
        }
        return cpBuffer.toString();
    }

    private String getLog4jConfigFile() {
        String resourceName = "cobertura-plugin/log4j-info.properties";
        if (this.getLog().isDebugEnabled()) {
            resourceName = "cobertura-plugin/log4j-debug.properties";
        }
        if (this.quiet) {
            resourceName = "cobertura-plugin/log4j-error.properties";
        }
        String path = null;
        try {
            File log4jconfigFile = File.createTempFile("log4j", "config.properties");
            URL log4jurl = this.getClass().getClassLoader().getResource(resourceName);
            FileUtils.copyURLToFile((URL)log4jurl, (File)log4jconfigFile);
            log4jconfigFile.deleteOnExit();
            path = log4jconfigFile.toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    public abstract void execute() throws MojoExecutionException, MojoFailureException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int executeJava() throws MojoExecutionException {
        String stream;
        int exitCode;
        Commandline cl = new Commandline();
        File java = new File(SystemUtils.getJavaHome(), "bin/java");
        cl.setExecutable(java.getAbsolutePath());
        cl.createArg().setValue("-cp");
        cl.createArg().setValue(this.createClasspath());
        String log4jConfig = this.getLog4jConfigFile();
        if (log4jConfig != null) {
            cl.createArg().setValue("-Dlog4j.configuration=" + log4jConfig);
        }
        cl.createArg().setValue("-Xmx" + this.maxmem);
        cl.createArg().setValue(this.taskClass);
        if (this.cmdLineArgs.useCommandsFile()) {
            String commandsFile;
            try {
                commandsFile = this.cmdLineArgs.getCommandsFile();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to obtain CommandsFile location.", (Exception)e);
            }
            if (!FileUtils.fileExists((String)commandsFile)) throw new MojoExecutionException("CommandsFile doesn't exist: " + commandsFile);
            cl.createArg().setValue("--commandsfile");
            cl.createArg().setValue(commandsFile);
        } else {
            Iterator<String> it = this.cmdLineArgs.iterator();
            while (it.hasNext()) {
                cl.createArg().setValue(it.next());
            }
        }
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        if (this.quiet) {
            CommandLineUtils.StringStreamConsumer nullConsumer;
            stdout = nullConsumer = new CommandLineUtils.StringStreamConsumer(){

                public void consumeLine(String line) {
                }
            };
            stderr = nullConsumer;
        }
        this.getLog().debug((CharSequence)("Working Directory: " + cl.getWorkingDirectory()));
        this.getLog().debug((CharSequence)"Executing command line:");
        this.getLog().debug((CharSequence)cl.toString());
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute Cobertura.", (Exception)((Object)e));
        }
        this.getLog().debug((CharSequence)("exit code: " + exitCode));
        String output = stdout.getOutput();
        if (output.trim().length() > 0) {
            this.getLog().debug((CharSequence)"--------------------");
            this.getLog().debug((CharSequence)" Standard output from the Cobertura task:");
            this.getLog().debug((CharSequence)"--------------------");
            this.getLog().info((CharSequence)output);
            this.getLog().debug((CharSequence)"--------------------");
        }
        if ((stream = stderr.getOutput()).trim().length() <= 0) return exitCode;
        this.getLog().debug((CharSequence)"--------------------");
        this.getLog().debug((CharSequence)" Standard error from the Cobertura task:");
        this.getLog().debug((CharSequence)"--------------------");
        this.getLog().error((CharSequence)stderr.getOutput());
        this.getLog().debug((CharSequence)"--------------------");
        return exitCode;
    }

    public CommandLineArguments getCmdLineArgs() {
        return this.cmdLineArgs;
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public String getMaxmem() {
        return this.maxmem;
    }

    public List<Artifact> getPluginClasspathList() {
        return this.pluginClasspathList;
    }

    public void setCmdLineArgs(CommandLineArguments cmdLineArgs) {
        this.cmdLineArgs = cmdLineArgs;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setMaxmem(String maxmem) {
        this.maxmem = maxmem;
    }

    public void setPluginClasspathList(List<Artifact> pluginClasspathList) {
        this.pluginClasspathList = Collections.unmodifiableList(pluginClasspathList);
    }
}

