/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura;

import java.io.File;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.PackageData;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.util.Header;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.cobertura.AbstractCoberturaMojo;

public class CoberturaDatafileDumpMojo
extends AbstractCoberturaMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.dataFile == null || !this.dataFile.exists()) {
            throw new MojoExecutionException("Unable to dump non-existance dataFile [" + this.dataFile + "]");
        }
        ProjectData projectData = CoverageDataFileHandler.loadCoverageData((File)this.dataFile);
        NumberFormat percentage = NumberFormat.getPercentInstance();
        this.println("<?xml version=\"1.0\"?>");
        this.println("<coverage line-rate=\"" + percentage.format(projectData.getLineCoverageRate()) + "\" branch-rate=\"" + percentage.format(projectData.getBranchCoverageRate()) + "\" version=\"" + Header.version() + "\" timestamp=\"" + new Date().getTime() + "\">");
        Iterator it = projectData.getPackages().iterator();
        while (it.hasNext()) {
            PackageData packageData = (PackageData)it.next();
            this.println("<package name=\"" + packageData.getName() + "\" line-rate=\"" + percentage.format(packageData.getLineCoverageRate()) + "\" branch-rate=\"" + percentage.format(packageData.getBranchCoverageRate()) + "\" />");
        }
        this.println("</coverage>");
    }

    private void println(String msg) {
        System.out.println(msg);
    }
}

