/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConfigInstrumentation {
    private File basedir;
    private List excludes;
    private List ignores;
    private List includes = new ArrayList();

    public ConfigInstrumentation() {
        this.excludes = new ArrayList();
        this.ignores = new ArrayList();
        this.basedir = new File(System.getProperty("user.dir"));
    }

    public void addExclude(String exclude) {
        this.excludes.add(exclude);
    }

    public void addIgnore(String ignore) {
        this.ignores.add(ignore);
    }

    public void addInclude(String include) {
        this.includes.add(include);
    }

    public File getBasedir() {
        return this.basedir;
    }

    public List getExcludes() {
        return this.excludes;
    }

    public List getIgnores() {
        return this.ignores;
    }

    public List getIncludes() {
        return this.includes;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String toString() {
        Iterator it;
        StringBuffer sb = new StringBuffer();
        sb.append("<ConfigInstrumentation");
        sb.append(" basedir=\"");
        if (this.basedir != null) {
            sb.append(this.basedir.getAbsolutePath());
        }
        sb.append("\"");
        if (!this.includes.isEmpty()) {
            sb.append(" includes=\"");
            it = this.includes.iterator();
            while (it.hasNext()) {
                String include = (String)it.next();
                sb.append(include);
                if (!it.hasNext()) continue;
                sb.append(" ");
            }
            sb.append("\"");
        }
        if (!this.excludes.isEmpty()) {
            sb.append(" excludes=\"");
            it = this.excludes.iterator();
            while (it.hasNext()) {
                String exclude = (String)it.next();
                sb.append(exclude);
                if (!it.hasNext()) continue;
                sb.append(" ");
            }
            sb.append("\"");
        }
        if (!this.ignores.isEmpty()) {
            sb.append(" ignores=\"");
            it = this.ignores.iterator();
            while (it.hasNext()) {
                String ignore = (String)it.next();
                sb.append(ignore);
                if (!it.hasNext()) continue;
                sb.append(" ");
            }
            sb.append("\"");
        }
        return sb.append(" />").toString();
    }
}

