/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.util.Iterator;
import java.util.Locale;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.Severity;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.clirr.AbstractClirrMojo;
import org.codehaus.mojo.clirr.ClirrDiffListener;
import org.codehaus.mojo.clirr.LogDiffListener;
import org.codehaus.mojo.clirr.MissingPreviousException;
import org.codehaus.plexus.i18n.I18N;

public class ClirrCheckMojo
extends AbstractClirrMojo {
    private boolean failOnError;
    private boolean failOnWarning;
    private boolean failOnInfo;
    private I18N i18n;

    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        ClirrDiffListener listener;
        if (!this.canGenerate()) {
            return;
        }
        try {
            listener = this.executeClirr();
        }
        catch (MissingPreviousException e) {
            this.getLog().debug((Throwable)((Object)e));
            this.getLog().info((CharSequence)"No previous version was found. Use 'comparisonArtifacts' for explicit configuration if you think this is wrong.");
            return;
        }
        Locale locale = Locale.getDefault();
        int errorCount = listener.getSeverityCount(Severity.ERROR);
        if (this.failOnError && errorCount > 0) {
            String message;
            this.log(listener, Severity.ERROR);
            if (errorCount > 1) {
                Object[] args = new String[]{String.valueOf(errorCount)};
                message = this.i18n.format("clirr-report", locale, "check.clirr.failure.errors", args);
            } else {
                message = this.i18n.getString("clirr-report", locale, "check.clirr.failure.error");
            }
            throw new MojoFailureException(message);
        }
        int warningCount = listener.getSeverityCount(Severity.WARNING);
        if (this.failOnWarning && warningCount > 0) {
            String message;
            this.log(listener, Severity.WARNING);
            if (warningCount > 1) {
                Object[] args = new String[]{String.valueOf(warningCount)};
                message = this.i18n.format("clirr-report", locale, "check.clirr.failure.warnings", args);
            } else {
                message = this.i18n.getString("clirr-report", locale, "check.clirr.failure.warning");
            }
            throw new MojoFailureException(message);
        }
        int infoCount = listener.getSeverityCount(Severity.INFO);
        if (this.failOnInfo && infoCount > 0) {
            String message;
            this.log(listener, Severity.INFO);
            if (infoCount > 1) {
                Object[] args = new String[]{String.valueOf(infoCount)};
                message = this.i18n.format("clirr-report", locale, "check.clirr.failure.infos", args);
            } else {
                message = this.i18n.getString("clirr-report", locale, "check.clirr.failure.info");
            }
            throw new MojoFailureException(message);
        }
        Object[] args = new String[]{String.valueOf(errorCount), String.valueOf(warningCount), String.valueOf(infoCount)};
        this.getLog().info((CharSequence)this.i18n.format("clirr-report", locale, "check.clirr.success", args));
    }

    private void log(ClirrDiffListener listener, Severity severity) {
        if (!this.logResults) {
            LogDiffListener l = new LogDiffListener(this.getLog());
            Iterator i = listener.getApiDifferences().iterator();
            while (i.hasNext()) {
                ApiDifference difference = (ApiDifference)i.next();
                if (!difference.getMaximumSeverity().equals(severity)) continue;
                l.reportDiff(difference);
            }
        }
    }
}

