/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private static final int DEFAULT_WIDTH = 80;
    private static final String DEFAULT_INDENT = HelpMojo.repeat(" ", 2);
    private boolean detail;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        sb.append("The 'org.codehaus.mojo:clirr-maven-plugin' plugin has 3 goals:").append("\n");
        sb.append("\n");
        sb.append("clirr:clirr").append("\n");
        Iterator it = HelpMojo.toLines("Generate a report from the Clirr output.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.detail) {
            sb.append("\n");
            sb.append(HelpMojo.repeat(" ", 2));
            sb.append("Available parameters:").append("\n");
            sb.append("\n");
            it = HelpMojo.toLines("classesDirectory (Default: '${project.build.outputDirectory}')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The classes of this project to compare the last release against.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("comparisonArtifacts", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("List of artifacts to compare the current code against. This overrides comparisonVersion, if present. Each comparisonArtifact is made of a groupId, an artifactId, a version number. Optionally it may have a classifier (default null) and a type (default 'jar').", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("comparisonVersion (Default: '(,${project.version})')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Version to compare the current code against.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("excludes", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("A list of classes to exclude. These classes are excluded from the list of classes that are included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("htmlReport (Default: 'true')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Whether to render the HTML report or not.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("includes", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("A list of classes to include. Anything not included is excluded. If omitted, all are assumed to be included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("linkXRef (Default: 'true')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Link the violation line numbers to the source xref. Defaults to true and will link automatically if jxr plugin is being used.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("logResults (Default: 'false')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Whether to log the results to the console or not.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("minSeverity (Default: 'warning')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Show only messages of this severity or higher. Valid values are info, warning and error.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("outputDirectory (Default: '${project.reporting.outputDirectory}')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Specifies the directory where the report will be generated.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("showSummary (Default: 'true')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Whether to show the summary of the number of errors, warnings and informational messages.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("textOutputFile", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("A text output file to render to. If omitted, no output is rendered to a text file.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("xmlOutputFile", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("An XML file to render to. If omitted, no output is rendered to an XML file.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("xrefLocation (Default: '${project.build.directory}/site/xref')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Location of the Xrefs to link to.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
        }
        sb.append("\n");
        sb.append("clirr:check").append("\n");
        it = HelpMojo.toLines("Check for compatibility with previous versions.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.detail) {
            sb.append("\n");
            sb.append(HelpMojo.repeat(" ", 2));
            sb.append("Available parameters:").append("\n");
            sb.append("\n");
            it = HelpMojo.toLines("classesDirectory (Default: '${project.build.outputDirectory}')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The classes of this project to compare the last release against.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("comparisonArtifacts", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("List of artifacts to compare the current code against. This overrides comparisonVersion, if present. Each comparisonArtifact is made of a groupId, an artifactId, a version number. Optionally it may have a classifier (default null) and a type (default 'jar').", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("comparisonVersion (Default: '(,${project.version})')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Version to compare the current code against.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("excludes", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("A list of classes to exclude. These classes are excluded from the list of classes that are included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("failOnError (Default: 'true')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Whether to fail on errors.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("failOnWarning (Default: 'false')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Whether to fail on warnings.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("includes", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("A list of classes to include. Anything not included is excluded. If omitted, all are assumed to be included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("logResults (Default: 'false')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Whether to log the results to the console or not.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("textOutputFile", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("A text output file to render to. If omitted, no output is rendered to a text file.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("xmlOutputFile", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("An XML file to render to. If omitted, no output is rendered to an XML file.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
        }
        sb.append("\n");
        sb.append("clirr:help").append("\n");
        it = HelpMojo.toLines("Display help information on 'org.codehaus.mojo:clirr-maven-plugin' plugin. Call 'mvn clirr:help -Ddetail=true' to display all details.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private static List toLines(String str) {
        return HelpMojo.toLines(str, DEFAULT_INDENT, 80);
    }

    private static List toLines(String str, String indent, int size) {
        ArrayList<String> sentences = new ArrayList<String>();
        if (indent == null) {
            indent = "";
        }
        if (size < 0) {
            throw new IllegalArgumentException("size should be positive");
        }
        StringBuffer tmp = new StringBuffer(indent);
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (tmp.length() + word.length() + 1 < size) {
                tmp.append(word).append(" ");
                continue;
            }
            sentences.add(tmp.toString());
            tmp = new StringBuffer(indent);
            tmp.append(word).append(" ");
        }
        if (tmp.toString().length() > 0) {
            sentences.add(tmp.toString());
        }
        return sentences;
    }
}

