package org.codehaus.mojo.clirr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on 'org.codehaus.mojo:clirr-maven-plugin' plugin. Call 'mvn clirr:help -Ddetail=true' to display all details.
 *
 * @version generated on Mon Jun 30 17:22:16 CEST 2008
 * @goal help
 */
public class HelpMojo
    extends AbstractMojo
{
    /** 80-character display buffer */
    private static final int DEFAULT_WIDTH = 80;

    /** 4 indent spaces */
    private static final String DEFAULT_INDENT = repeat( " ", 2 );

    /**
     * If true, display all settable properies for each goal.
     *
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        StringBuffer sb = new StringBuffer();

        sb.append( "The 'org.codehaus.mojo:clirr-maven-plugin' plugin has 4 goals:" ).append( "\n" );
        sb.append( "\n" );

        sb.append( "clirr:clirr" ).append( "\n" );
        for ( Iterator it = toLines( "Generate a report from the Clirr output." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
        if ( detail )
        {
            sb.append( "\n" );

            sb.append( repeat( " ", 2 ) );
            sb.append( "Available parameters:" ).append( "\n" );

            sb.append( "\n" );

        for ( Iterator it = toLines( "classesDirectory (Default: '${project.build.outputDirectory}')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The classes of this project to compare the last release against.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "comparisonArtifacts", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "List of artifacts to compare the current code against. This overrides comparisonVersion, if present. Each comparisonArtifact is made of a groupId, an artifactId, a version number. Optionally it may have a classifier (default null) and a type (default 'jar').", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "comparisonVersion (Default: '(,${project.version})')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Version to compare the current code against.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "excludes", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "A list of classes to exclude. These classes are excluded from the list of classes that are included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "htmlReport (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Whether to render the HTML report or not.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "includes", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "A list of classes to include. Anything not included is excluded. If omitted, all are assumed to be included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "linkXRef (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Link the violation line numbers to the source xref. Defaults to true and will link automatically if jxr plugin is being used.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "logResults (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Whether to log the results to the console or not.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "minSeverity (Default: 'warning')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Show only messages of this severity or higher. Valid values are info, warning and error.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "outputDirectory (Default: '${project.reporting.outputDirectory}')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the directory where the report will be generated.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "showSummary (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Whether to show the summary of the number of errors, warnings and informational messages.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "textOutputFile", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "A text output file to render to. If omitted, no output is rendered to a text file.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "xmlOutputFile", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "An XML file to render to. If omitted, no output is rendered to an XML file.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "xrefLocation (Default: '${project.build.directory}/site/xref')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Location of the Xrefs to link to.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        }

        sb.append( "\n" );

        sb.append( "clirr:check" ).append( "\n" );
        for ( Iterator it = toLines( "Check for compatibility with previous versions." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
        if ( detail )
        {
            sb.append( "\n" );

            sb.append( repeat( " ", 2 ) );
            sb.append( "Available parameters:" ).append( "\n" );

            sb.append( "\n" );

        for ( Iterator it = toLines( "classesDirectory (Default: '${project.build.outputDirectory}')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The classes of this project to compare the last release against.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "comparisonArtifacts", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "List of artifacts to compare the current code against. This overrides comparisonVersion, if present. Each comparisonArtifact is made of a groupId, an artifactId, a version number. Optionally it may have a classifier (default null) and a type (default 'jar').", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "comparisonVersion (Default: '(,${project.version})')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Version to compare the current code against.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "excludes", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "A list of classes to exclude. These classes are excluded from the list of classes that are included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "failOnError (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Whether to fail on errors.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "failOnWarning (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Whether to fail on warnings.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "includes", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "A list of classes to include. Anything not included is excluded. If omitted, all are assumed to be included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "logResults (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Whether to log the results to the console or not.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "textOutputFile", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "A text output file to render to. If omitted, no output is rendered to a text file.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "xmlOutputFile", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "An XML file to render to. If omitted, no output is rendered to an XML file.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        }

        sb.append( "\n" );

        sb.append( "clirr:help" ).append( "\n" );
        for ( Iterator it = toLines( "Display help information on 'org.codehaus.mojo:clirr-maven-plugin' plugin. Call 'mvn clirr:help -Ddetail=true' to display all details." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
        if ( detail )
        {
            sb.append( "\n" );

            sb.append( repeat( " ", 2 ) );
            sb.append( "Available parameters:" ).append( "\n" );

            sb.append( "\n" );

        for ( Iterator it = toLines( "detail (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "If true, display all settable properies for each goal.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        }

        sb.append( "\n" );

        sb.append( "clirr:help" ).append( "\n" );
        for ( Iterator it = toLines( "Display help information on 'org.codehaus.mojo:clirr-maven-plugin' plugin. Call 'mvn clirr:help -Ddetail=true' to display all details." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /**
     * <p>Give a list of lines for the <code>str</code>. Each line is indented by 4 spaces
     * and has a maximum of <code>80</code> characters.</p>
     *
     * @param str String to split in lines
     * @return List of lines
     * @throws NullPointerException if str is <code>null</code>
     */
    private static List toLines( String str )
    {
        return toLines( str, DEFAULT_INDENT, DEFAULT_WIDTH );
    }

    /**
     * <p>Give a list of lines for the <code>str</code>. Each line is indented by <code>indent</code>
     * and has a maximum of <code>size</code> characters.</p>
     *
     * @param str String to split in lines
     * @param indent the string to precede each line
     * @param size the size of the character display buffer
     * @return List of lines
     * @throws IllegalArgumentException if <code>size < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static List toLines( String str, String indent, int size )
    {
        List sentences = new ArrayList();

        if ( indent == null )
        {
            indent = "";
        }

        if ( size < 0 )
        {
            throw new IllegalArgumentException( "size should be positive" );
        }

        StringBuffer tmp = new StringBuffer( indent );
        StringTokenizer tokenizer = new StringTokenizer( str, " " );
        while ( tokenizer.hasMoreTokens() )
        {
            String word = tokenizer.nextToken();

            if ( tmp.length() + word.length() + 1 < size )
            {
                tmp.append( word ).append( " " );
            }
            else
            {
                sentences.add( tmp.toString() );
                tmp = new StringBuffer( indent );
                tmp.append( word ).append( " " );
            }
        }

        if ( tmp.toString().length() > 0 )
        {
            sentences.add( tmp.toString() );
        }

        return sentences;
    }
}
