/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report.chart;

import java.awt.Color;
import java.awt.Paint;
import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import org.codehaus.mojo.chronos.common.model.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.report.ReportConfig;
import org.codehaus.mojo.chronos.report.chart.ChartSource;
import org.codehaus.mojo.chronos.report.chart.ChartUtil;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.SeriesRenderingOrder;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public final class SummaryThroughputChartSource
implements ChartSource {
    private GroupedResponsetimeSamples samples;

    public SummaryThroughputChartSource(GroupedResponsetimeSamples samples) {
        this.samples = samples;
    }

    public boolean isEnabled(ReportConfig config) {
        return config.isShowthroughput();
    }

    public String getFileName(ReportConfig config) {
        return "throughput-" + config.getId();
    }

    public JFreeChart getChart(ResourceBundle bundle, ReportConfig config) {
        XYPlot throughputPlot = this.createThroughputPlot(bundle, config);
        XYPlot threadCountPlot = this.createThreadCountPlot(bundle);
        DateAxis timeAxis = this.createTimeAxis(bundle);
        CombinedDomainXYPlot combinedPlot = ChartUtil.createCombinedPlot(timeAxis, throughputPlot, threadCountPlot);
        return new JFreeChart(bundle.getString("chronos.label.throughput"), (Plot)combinedPlot);
    }

    private XYPlot createThroughputPlot(ResourceBundle bundle, ReportConfig config) {
        TimeSeries series = this.samples.createMovingThroughput(bundle.getString("chronos.label.throughput"));
        TimeSeries averageseries = this.createMovingAverage(series, bundle, config);
        TimeSeriesCollection seriesCollection = SummaryThroughputChartSource.asCollection(series, averageseries);
        String verticalLabel = bundle.getString("chronos.label.throughput.requests");
        XYPlot throughputPlot = ChartUtil.newPlot(verticalLabel, true, (XYDataset)seriesCollection);
        throughputPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        throughputPlot.getRenderer().setSeriesPaint(0, (Paint)Color.GREEN);
        throughputPlot.getRenderer().setSeriesPaint(1, (Paint)Color.BLUE);
        throughputPlot.setSeriesRenderingOrder(SeriesRenderingOrder.FORWARD);
        double maxAvgThroughput = this.samples.getMaxAverageThroughput(config.getAverageduration());
        String labelAverage = bundle.getString("chronos.label.maxaveragethroughput");
        ChartUtil.addRangeMarker(throughputPlot, labelAverage, maxAvgThroughput);
        return throughputPlot;
    }

    private TimeSeries createMovingAverage(TimeSeries series, ResourceBundle bundle, ReportConfig config) {
        int avgDuration = config.getAverageduration();
        String label = bundle.getString("chronos.label.average");
        int periodCount = avgDuration;
        return MovingAverage.createMovingAverage((TimeSeries)series, (String)label, (int)periodCount, (int)0);
    }

    private XYPlot createThreadCountPlot(ResourceBundle bundle) {
        TimeSeries threadcountSeries = this.createThreadCount();
        String label = bundle.getString("chronos.label.threadcount.y");
        XYPlot threadCountPlot = ChartUtil.newPlot(label, false, (XYDataset)SummaryThroughputChartSource.asCollection(threadcountSeries));
        threadCountPlot.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        threadCountPlot.getRenderer().setSeriesPaint(0, (Paint)Color.GRAY);
        return threadCountPlot;
    }

    private TimeSeries createThreadCount() {
        return this.samples.getThreadCount();
    }

    private static TimeSeriesCollection asCollection(TimeSeries ... seriesCollection) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        for (TimeSeries timeSeries : seriesCollection) {
            dataset.addSeries(timeSeries);
        }
        return dataset;
    }

    private DateAxis createTimeAxis(ResourceBundle bundle) {
        String label = bundle.getString("chronos.label.throughput.time");
        return ChartUtil.createTimeAxis(label, new SimpleDateFormat("HH:mm:ss"));
    }
}

