/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report.chart;

import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSamples;
import org.codehaus.mojo.chronos.report.ReportConfig;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

public class ChartUtil {
    private static final double GAP = 10.0;
    private static final double MARGIN = 0.02;
    private static final int BINS = 100;
    private static final float FOREGROUND_ALPHA = 0.85f;

    public static void addDomainMarker(XYPlot xyplot, String label, double value) {
        xyplot.addDomainMarker((Marker)ChartUtil.addValueMarker(label, value, true));
    }

    public static void addRangeMarker(XYPlot xyplot, String label, double value) {
        xyplot.addRangeMarker((Marker)ChartUtil.addValueMarker(label, value, false));
    }

    public static XYPlot newPlot(TimeSeries timeSeries, String label, boolean forceIncludeZero) {
        XYDataset dataset = ChartUtil.asDataset(timeSeries);
        return ChartUtil.newPlot(label, forceIncludeZero, dataset);
    }

    public static XYPlot setUpperBound(JFreeChart chart, double max) {
        XYPlot plot = chart.getXYPlot();
        ValueAxis axis = plot.getDomainAxis();
        axis.setUpperBound(max);
        return plot;
    }

    public static XYPlot setupXYPlot(JFreeChart chart, DateFormat dateFormat) {
        XYPlot plot = chart.getXYPlot();
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride(dateFormat);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return plot;
    }

    static CombinedDomainXYPlot createCombinedPlot(DateAxis timeAxis, XYPlot xyplot1, XYPlot xyplot2) {
        CombinedDomainXYPlot combineddomainxyplot = new CombinedDomainXYPlot((ValueAxis)timeAxis);
        combineddomainxyplot.setGap(10.0);
        combineddomainxyplot.add(xyplot1, 2);
        combineddomainxyplot.add(xyplot2, 1);
        combineddomainxyplot.setOrientation(PlotOrientation.VERTICAL);
        return combineddomainxyplot;
    }

    static DateAxis createTimeAxis(String label, SimpleDateFormat dateFormat) {
        DateAxis timeAxis = new DateAxis(label);
        timeAxis.setDateFormatOverride((DateFormat)dateFormat);
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        return timeAxis;
    }

    static XYPlot newPlot(String verticalLabel, boolean forceIncludeZero, XYDataset dataset) {
        StandardXYItemRenderer standardxyitemrenderer = new StandardXYItemRenderer();
        NumberAxis numberaxis = new NumberAxis(verticalLabel);
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberaxis.setAutoRangeIncludesZero(forceIncludeZero);
        return new XYPlot(dataset, null, (ValueAxis)numberaxis, (XYItemRenderer)standardxyitemrenderer);
    }

    private static ValueMarker addValueMarker(String text, double x, boolean domain) {
        ValueMarker marker = new ValueMarker(x);
        marker.setPaint((Paint)Color.GRAY);
        marker.setLabel(text);
        if (domain) {
            marker.setLabelAnchor(RectangleAnchor.TOP_LEFT);
            marker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
        } else {
            marker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            marker.setLabelTextAnchor(TextAnchor.BOTTOM_RIGHT);
        }
        return marker;
    }

    private static XYDataset asDataset(TimeSeries series) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(series);
        return dataset;
    }

    public static JFreeChart createTimeSeriesChart(XYDataset dataset, String title, String timeAxisLabel, String valueAxisLabel) {
        DateAxis timeAxis = new DateAxis(timeAxisLabel, TimeZone.getTimeZone("GMT"), Locale.getDefault());
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        valueAxis.setAutoRangeIncludesZero(false);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        StandardXYToolTipGenerator toolTipGenerator = StandardXYToolTipGenerator.getTimeSeriesInstance();
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)toolTipGenerator);
        XYPlot plot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, null);
        plot.setRenderer((XYItemRenderer)renderer);
        boolean addLegend = true;
        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, addLegend);
    }

    protected static JFreeChart createHistogramChart(ResponsetimeSamples samples, String label, ResourceBundle bundle, ReportConfig config) {
        double value;
        HistogramDataset histogramdataset = new HistogramDataset();
        double[] sampleArray = samples.extractResponsetimes();
        histogramdataset.addSeries((Comparable)((Object)label), sampleArray, 100);
        JFreeChart chart = ChartFactory.createHistogram((String)bundle.getString("chronos.label.histogram"), (String)bundle.getString("chronos.label.histogram.x"), (String)bundle.getString("chronos.label.histogram.y"), (IntervalXYDataset)histogramdataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        xyplot.setForegroundAlpha(0.85f);
        XYBarRenderer xybarrenderer = (XYBarRenderer)xyplot.getRenderer();
        xybarrenderer.setDrawBarOutline(false);
        if (config.isShowpercentile95()) {
            String label95 = bundle.getString("chronos.label.percentile95.arrow");
            value = samples.getPercentile95();
            ChartUtil.addDomainMarker(xyplot, label95, value);
        }
        if (config.isShowpercentile99()) {
            String label99 = bundle.getString("chronos.label.percentile99.arrow");
            value = samples.getPercentile99();
            ChartUtil.addDomainMarker(xyplot, label99, value);
        }
        if (config.isShowaverage()) {
            String label2 = bundle.getString("chronos.label.average.arrow");
            value = samples.getAverage();
            ChartUtil.addDomainMarker(xyplot, label2, value);
        }
        return chart;
    }
}

