/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.cassandra.Utils;

@Mojo(name="stop-cluster", threadSafe=true, defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class StopCassandraClusterMojo
extends AbstractMojo {
    @Parameter(property="cassandra.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="cassandra.stopPort", defaultValue="8081", required=true)
    protected int stopPort;
    @Parameter(property="cassandra.stopKey", defaultValue="cassandra-maven-plugin", required=true)
    protected String stopKey;
    @Parameter(defaultValue="127.0.0.1")
    private String rpcAddress;
    @Parameter(property="cassandra.rpcPort", defaultValue="9160")
    protected int rpcPort;
    @Parameter(property="cassandra.cluster.size", defaultValue="4")
    private int clusterSize;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cassandra: cassandra.skip==true");
            return;
        }
        if (this.stopPort <= 0) {
            throw new MojoExecutionException("Please specify a valid port");
        }
        if (this.stopKey == null) {
            throw new MojoExecutionException("Please specify a valid stopKey");
        }
        if (this.clusterSize < 1) {
            throw new MojoExecutionException("Invalid cluster size of " + this.clusterSize + " specified. Must be at least 1");
        }
        if (this.clusterSize > 254) {
            throw new MojoExecutionException("Invalid cluster size of " + this.clusterSize + " specified. Must be less than 254");
        }
        for (int node = 0; node < this.clusterSize; ++node) {
            Utils.stopCassandraServer("127.0.0." + (node + 1), this.rpcPort, "127.0.0." + (node + 1), this.stopPort, this.stopKey, this.getLog());
        }
    }
}

